class FasterThanLightError(Exception):
    ...


# OK
def calculate_speed(distance: float, time: float) -> float:
    """
    Calculate speed as distance divided by time.

    Parameters
    ----------
    distance : float
        Distance traveled.
    time : float
        Time spent traveling.

    Returns
    -------
    float
        Speed as distance divided by time.

    Raises
    ------
    FasterThanLightError
        If speed is greater than the speed of light.
    """
    try:
        return distance / time
    except ZeroDivisionError as exc:
        raise FasterThanLightError from exc


# DOC501
def calculate_speed(distance: float, time: float) -> float:
    """
    Calculate speed as distance divided by time.

    Parameters
    ----------
    distance : float
        Distance traveled.
    time : float
        Time spent traveling.

    Returns
    -------
    float
        Speed as distance divided by time.
    """
    try:
        return distance / time
    except ZeroDivisionError as exc:
        raise FasterThanLightError from exc


# DOC501
def calculate_speed(distance: float, time: float) -> float:
    """
    Calculate speed as distance divided by time.

    Parameters
    ----------
    distance : float
        Distance traveled.
    time : float
        Time spent traveling.

    Returns
    -------
    float
        Speed as distance divided by time.
    """
    try:
        return distance / time
    except ZeroDivisionError as exc:
        raise FasterThanLightError from exc
    except:
        raise ValueError


# DOC501
def calculate_speed(distance: float, time: float) -> float:
    """Calculate speed as distance divided by time.

    ACalculate speed as distance divided by time.

    Parameters
    ----------
    distance : float
        Distance traveled.
    time : float
        Time spent traveling.

    Returns
    -------
    float
        Speed as distance divided by time.

    Raises
    ------
    ZeroDivisionError
        If attempting to divide by zero.
    """
    try:
        return distance / time
    except ZeroDivisionError:
        print("Oh no, why would you divide something by zero?")
        raise
    except TypeError:
        print("Not a number? Shame on you!")
        raise


# This is fine
def calculate_speed(distance: float, time: float) -> float:
    """
    Calculate speed as distance divided by time.

    Parameters
    ----------
    distance : float
        Distance traveled.
    time : float
        Time spent traveling.

    Returns
    -------
    float
        Speed as distance divided by time.
    """
    try:
        return distance / time
    except Exception as e:
        print(f"Oh no, we encountered {e}")
        raise


def foo():
    """Foo.

    Returns
    -------
    int
        42
    """
    if True:
        raise TypeError  # DOC501
    else:
        raise TypeError  # no DOC501 here because we already emitted a diagnostic for the earlier `raise TypeError`
    raise ValueError  # DOC501
    return 42
