/*
 * Decompiled with CFR 0.152.
 */
package io.bazel.kotlin.builder.utils.jars;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u0016\u0018\u0000 #2\u00020\u0001:\u0001#B-\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J \u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0004J\u001c\u0010 \u001a\u00020\u0019*\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u0003H\u0004J*\u0010 \u001a\u00020\u0019*\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\r2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\"\u001a\u00020\u001eH\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006$"}, d2={"Lio/bazel/kotlin/builder/utils/jars/JarHelper;", "", "jarPath", "Ljava/nio/file/Path;", "normalize", "", "verbose", "compression", "(Ljava/nio/file/Path;ZZZ)V", "getJarPath", "()Ljava/nio/file/Path;", "names", "", "", "getNormalize", "()Z", "storageMethod", "", "getVerbose", "newEntryTimeMillis", "", "filename", "normalizedTimestamp", "name", "setCompression", "", "writeEntry", "out", "Ljava/util/jar/JarOutputStream;", "content", "", "writeManifestEntry", "copyEntry", "path", "data", "Companion", "src_main_kotlin_io_bazel_kotlin_builder_utils_jars-jars"})
public class JarHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path jarPath;
    private final boolean normalize;
    private final boolean verbose;
    private int storageMethod;
    @NotNull
    private final Set<String> names;
    @NotNull
    public static final String MANIFEST_DIR = "META-INF/";
    @NotNull
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    @NotNull
    public static final String SERVICES_DIR = "META-INF/services/";
    @NotNull
    private static final byte[] EMPTY_BYTEARRAY = new byte[0];
    private static final long DEFAULT_TIMESTAMP = new GregorianCalendar(1980, 1, 1, 0, 0, 0).getTimeInMillis();
    @NotNull
    private static final Attributes.Name TARGET_LABEL = new Attributes.Name("Target-Label");
    @NotNull
    private static final Attributes.Name INJECTING_RULE_KIND = new Attributes.Name("Injecting-Rule-Kind");
    public static final long MINIMUM_TIMESTAMP_INCREMENT = 2000L;

    public JarHelper(@NotNull Path jarPath, boolean normalize, boolean verbose, boolean compression) {
        Intrinsics.checkNotNullParameter(jarPath, "jarPath");
        this.jarPath = jarPath;
        this.normalize = normalize;
        this.verbose = verbose;
        this.storageMethod = 8;
        this.names = new HashSet();
        this.setCompression(compression);
    }

    public /* synthetic */ JarHelper(Path path, boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = true;
        }
        this(path, bl, bl2, bl3);
    }

    @NotNull
    protected final Path getJarPath() {
        return this.jarPath;
    }

    protected final boolean getNormalize() {
        return this.normalize;
    }

    protected final boolean getVerbose() {
        return this.verbose;
    }

    private final void setCompression(boolean compression) {
        this.storageMethod = compression ? 8 : 0;
    }

    private final long normalizedTimestamp(String name) {
        return StringsKt.endsWith$default(name, ".class", false, 2, null) ? DEFAULT_TIMESTAMP + 2000L : DEFAULT_TIMESTAMP;
    }

    private final long newEntryTimeMillis(String filename) {
        return this.normalize ? this.normalizedTimestamp(filename) : System.currentTimeMillis();
    }

    private final void writeEntry(JarOutputStream out2, String name, byte[] content) throws IOException {
        if (this.names.add(name)) {
            JarEntry entry2 = new JarEntry(name);
            entry2.setTime(this.newEntryTimeMillis(name));
            int size = content.length;
            entry2.setSize(size);
            if (size == 0) {
                entry2.setMethod(0);
                entry2.setCrc(0L);
                out2.putNextEntry(entry2);
            } else {
                entry2.setMethod(this.storageMethod);
                if (this.storageMethod == 0) {
                    CRC32 crc = new CRC32();
                    crc.update(content);
                    entry2.setCrc(crc.getValue());
                }
                out2.putNextEntry(entry2);
                out2.write(content);
            }
            out2.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeManifestEntry(@NotNull JarOutputStream out2, @NotNull byte[] content) throws IOException {
        Intrinsics.checkNotNullParameter(out2, "out");
        Intrinsics.checkNotNullParameter(content, "content");
        int oldStorageMethod = this.storageMethod;
        if (content.length < 256) {
            this.storageMethod = 0;
        }
        try {
            this.writeEntry(out2, MANIFEST_DIR, new byte[0]);
            this.writeEntry(out2, MANIFEST_NAME, content);
        }
        finally {
            this.storageMethod = oldStorageMethod;
        }
    }

    protected final void copyEntry(@NotNull JarOutputStream $this$copyEntry, @NotNull String name, @NotNull Path path) throws IOException {
        Intrinsics.checkNotNullParameter($this$copyEntry, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(path, "path");
        String normalizedName = name;
        if (!this.names.contains(normalizedName)) {
            if (!Files.exists(path, new LinkOption[0])) {
                throw new FileNotFoundException(path.toAbsolutePath() + " (No such file or directory)");
            }
            boolean isDirectory = Files.isDirectory(path, new LinkOption[0]);
            if (isDirectory && !StringsKt.endsWith$default(normalizedName, "/", false, 2, null)) {
                normalizedName = normalizedName + '/';
            }
            if (this.names.add(normalizedName)) {
                if (this.verbose) {
                    System.err.println("adding " + path);
                }
                long size = isDirectory ? 0L : Files.size(path);
                JarEntry outEntry = new JarEntry(normalizedName);
                long newtime = this.normalize ? this.normalizedTimestamp(normalizedName) : Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
                outEntry.setTime(newtime);
                outEntry.setSize(size);
                if (size == 0L) {
                    outEntry.setMethod(0);
                    outEntry.setCrc(0L);
                    $this$copyEntry.putNextEntry(outEntry);
                } else {
                    outEntry.setMethod(this.storageMethod);
                    if (this.storageMethod == 0) {
                        byte[] bytes = Files.readAllBytes(path);
                        CRC32 crc = new CRC32();
                        crc.update(bytes);
                        outEntry.setCrc(crc.getValue());
                        $this$copyEntry.putNextEntry(outEntry);
                        $this$copyEntry.write(bytes);
                    } else {
                        $this$copyEntry.putNextEntry(outEntry);
                        Files.copy(path, $this$copyEntry);
                    }
                }
                $this$copyEntry.closeEntry();
            }
        }
    }

    protected final void copyEntry(@NotNull JarOutputStream $this$copyEntry, @NotNull String name, @Nullable Path path, @NotNull byte[] data) {
        long l;
        Intrinsics.checkNotNullParameter($this$copyEntry, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(data, "data");
        JarEntry outEntry = new JarEntry(name);
        if (this.normalize) {
            l = this.normalizedTimestamp(name);
        } else {
            Path path2 = path;
            if (path2 == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            l = Files.getLastModifiedTime(path2, new LinkOption[0]).toMillis();
        }
        outEntry.setTime(l);
        outEntry.setSize(data.length);
        if (data.length == 0) {
            outEntry.setMethod(0);
            outEntry.setCrc(0L);
            $this$copyEntry.putNextEntry(outEntry);
        } else {
            outEntry.setMethod(this.storageMethod);
            if (this.storageMethod == 0) {
                CRC32 crc = new CRC32();
                crc.update(data);
                outEntry.setCrc(crc.getValue());
                $this$copyEntry.putNextEntry(outEntry);
                $this$copyEntry.write(data);
            } else {
                $this$copyEntry.putNextEntry(outEntry);
                $this$copyEntry.write(data);
            }
        }
        $this$copyEntry.closeEntry();
    }

    public static /* synthetic */ void copyEntry$default(JarHelper jarHelper, JarOutputStream jarOutputStream, String string, Path path, byte[] byArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copyEntry");
        }
        if ((n & 2) != 0) {
            path = null;
        }
        if ((n & 4) != 0) {
            byArray = EMPTY_BYTEARRAY;
        }
        jarHelper.copyEntry(jarOutputStream, string, path, byArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lio/bazel/kotlin/builder/utils/jars/JarHelper$Companion;", "", "()V", "DEFAULT_TIMESTAMP", "", "getDEFAULT_TIMESTAMP", "()J", "EMPTY_BYTEARRAY", "", "getEMPTY_BYTEARRAY$src_main_kotlin_io_bazel_kotlin_builder_utils_jars_jars", "()[B", "INJECTING_RULE_KIND", "Ljava/util/jar/Attributes$Name;", "getINJECTING_RULE_KIND", "()Ljava/util/jar/Attributes$Name;", "MANIFEST_DIR", "", "MANIFEST_NAME", "MINIMUM_TIMESTAMP_INCREMENT", "SERVICES_DIR", "TARGET_LABEL", "getTARGET_LABEL", "src_main_kotlin_io_bazel_kotlin_builder_utils_jars-jars"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] getEMPTY_BYTEARRAY$src_main_kotlin_io_bazel_kotlin_builder_utils_jars_jars() {
            return EMPTY_BYTEARRAY;
        }

        public final long getDEFAULT_TIMESTAMP() {
            return DEFAULT_TIMESTAMP;
        }

        @NotNull
        public final Attributes.Name getTARGET_LABEL() {
            return TARGET_LABEL;
        }

        @NotNull
        public final Attributes.Name getINJECTING_RULE_KIND() {
            return INJECTING_RULE_KIND;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

