/*
 * Decompiled with CFR 0.152.
 */
package io.bazel.kotlin.builder.guava.collect;

import io.bazel.kotlin.builder.guava.annotations.GwtCompatible;
import io.bazel.kotlin.builder.guava.annotations.GwtIncompatible;
import io.bazel.kotlin.builder.guava.annotations.J2ktIncompatible;
import io.bazel.kotlin.builder.guava.collect.CollectSpliterators;
import io.bazel.kotlin.builder.guava.collect.ElementTypesAreNonnullByDefault;
import io.bazel.kotlin.builder.guava.collect.ImmutableList;
import io.bazel.kotlin.builder.guava.collect.ImmutableSortedSet;
import io.bazel.kotlin.builder.guava.collect.RegularImmutableAsList;
import io.bazel.kotlin.builder.guava.collect.RegularImmutableSortedSet;
import io.bazel.kotlin.builder.guava.collect.SortedIterable;
import java.util.Comparator;
import java.util.Spliterator;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class ImmutableSortedAsList<E>
extends RegularImmutableAsList<E>
implements SortedIterable<E> {
    ImmutableSortedAsList(ImmutableSortedSet<E> backingSet, ImmutableList<E> backingList) {
        super(backingSet, backingList);
    }

    @Override
    ImmutableSortedSet<E> delegateCollection() {
        return (ImmutableSortedSet)super.delegateCollection();
    }

    @Override
    public Comparator<? super E> comparator() {
        return ((ImmutableSortedSet)this.delegateCollection()).comparator();
    }

    @Override
    @GwtIncompatible
    public int indexOf(@CheckForNull Object target) {
        int index = ((ImmutableSortedSet)this.delegateCollection()).indexOf(target);
        return index >= 0 && this.get(index).equals(target) ? index : -1;
    }

    @Override
    @GwtIncompatible
    public int lastIndexOf(@CheckForNull Object target) {
        return this.indexOf(target);
    }

    @Override
    public boolean contains(@CheckForNull Object target) {
        return this.indexOf(target) >= 0;
    }

    @Override
    @GwtIncompatible
    ImmutableList<E> subListUnchecked(int fromIndex, int toIndex) {
        ImmutableList parentSubList = super.subListUnchecked(fromIndex, toIndex);
        return new RegularImmutableSortedSet(parentSubList, this.comparator()).asList();
    }

    @Override
    public Spliterator<E> spliterator() {
        return CollectSpliterators.indexed(this.size(), 1301, this.delegateList()::get, this.comparator());
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }
}

