/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.jarjar;

import java.io.IOException;
import java.util.List;
import org.pantsbuild.jarjar.PatternElement;
import org.pantsbuild.jarjar.Wildcard;
import org.pantsbuild.jarjar.Zap;
import org.pantsbuild.jarjar.util.EntryStruct;
import org.pantsbuild.jarjar.util.JarProcessor;

class ZapProcessor
implements JarProcessor {
    private List<Wildcard> wildcards;

    public ZapProcessor(List<Zap> list) {
        this.wildcards = PatternElement.createWildcards(list);
    }

    @Override
    public boolean process(EntryStruct entryStruct) throws IOException {
        String string = entryStruct.name;
        if (string.endsWith(".class")) {
            return !this.zap(string.substring(0, string.length() - 6));
        }
        return true;
    }

    private boolean zap(String string) {
        for (Wildcard wildcard : this.wildcards) {
            if (!wildcard.matches(string)) continue;
            return true;
        }
        return false;
    }
}

