# Analysis options

Some analyses allows the user to interact with them directly on the command line, using so-called `options`. The options are arguments to analyses given on the
commandline (or through the API), which will change the behaviour of the analysis. At a glance, an option is given with the following syntax:

```
rivet <hepmc-file> -a <analysis-name>:<option-key>=<option-value>
```

## Example: centrality selection for heavy ion analysis

The most prevalent use case for analysis options, is in heavy ion analysis that bin observables in centrality. The user has the option to either select
the experimentally measured centrality observables, a user generated one equivalent to that, impact parameter also generated by the user, or a number, which
should then be present in the HepMC file. As an example, look at `ATLAS_2015_I1360290`. It allows the option with key `cent` to make this selection. So if the
user would prefer to stick to the experimentally measured values, the correct syntax would be:

```
rivet <hepmc-file> -a ATLAS_2015_I1360290:cent=REF
```
An analysis can be added multiple times, with different values for a given option. Rivet will then treat them as separate analyses. The syntax:
```
rivet <hepmc-file> -a ATLAS_2015_I1360290:cent=REF -a ATLAS_2015_I1360290:cent=RAW

```
adds the same analysis twice, with two different selections.



