// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/UnstableParticles.hh"
#include "Rivet/Projections/DecayedParticles.hh"

namespace Rivet {


  /// @brief D_s+ -> pi+ pi+ pi- pi0
  class BESIII_2024_I2801948 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(BESIII_2024_I2801948);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {
      // Initialise and register projections
      UnstableParticles ufs = UnstableParticles(Cuts::abspid==431);
      declare(ufs, "UFS");
      DecayedParticles DS(ufs);
      DS.addStable(PID::PI0);
      DS.addStable(PID::K0S);
      declare(DS,"DS");
      // histos
      for(unsigned int ix=0;ix<7;++ix)
        book(_h[ix],1,1,1+ix);
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      static const map<PdgId,unsigned int> & mode   = { { 211,2}, {-211,1}, { 111,1}};
      static const map<PdgId,unsigned int> & modeCC = { {-211,2}, { 211,1}, { 111,1}};
      DecayedParticles DS = apply<DecayedParticles>(event, "DS");
      // loop over particles
      for(unsigned int ix=0;ix<DS.decaying().size();++ix) {
	int sign = 1;
	if (DS.decaying()[ix].pid()>0 && DS.modeMatches(ix,4,mode)) {
	  sign=1;
	}
	else if  (DS.decaying()[ix].pid()<0 && DS.modeMatches(ix,4,modeCC)) {
	  sign=-1;
	}
	else
	  continue;
	const Particle  & pi0 = DS.decayProducts()[ix].at(      111)[0];
	const Particles & pip = DS.decayProducts()[ix].at( sign*211);
	const Particle  & pim = DS.decayProducts()[ix].at(-sign*211)[0];
        double mpm[2];
        bool veto=false;
        for(unsigned int ix=0;ix<2;++ix) {
          mpm[ix] = (pip[ix].momentum()+pim.momentum()).mass();
          if(mpm[ix]>0.46 && mpm[ix]<0.52) veto=true;
        }
        if(veto) continue;
        // eta veto
        double mpm0[2];
        for(unsigned int ix=0;ix<2;++ix) {
          mpm0[ix] = (pip[ix].momentum()+pim.momentum()+pi0.momentum()).mass();
          if(mpm0[ix]>0.52 && mpm0[ix]<0.58) veto=true;
        }
        if(veto) continue;
        _h[0]->fill((pip[0].momentum()+pip[1].momentum()).mass());
        _h[1]->fill((pim   .momentum()+pi0   .momentum()).mass());
        _h[4]->fill((pip[0].momentum()+pip[1].momentum()+pim.momentum()).mass());
        _h[5]->fill((pip[0].momentum()+pip[1].momentum()+pi0.momentum()).mass());
        for(unsigned int ix=0;ix<2;++ix) {
          _h[2]->fill(mpm[ix]);
          _h[3]->fill((pip[ix].momentum()+pi0.momentum()).mass());
          _h[6]->fill(mpm0[ix]);
        }
      }
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      normalize(_h);
    }

    /// @}


    /// @name Histograms
    /// @{
    Histo1DPtr _h[7];
    /// @}


  };


  RIVET_DECLARE_PLUGIN(BESIII_2024_I2801948);

}
