// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"
#include "Rivet/Projections/UnstableParticles.hh"

namespace Rivet {


  /// @brief Add a short analysis description here
  class BABAR_2008_I765258 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(BABAR_2008_I765258);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {

      // Initialise and register projections
      declare(FinalState(), "FS");
      declare(UnstableParticles(), "UFS");

      // Book histograms
      for(unsigned int ix=1;ix<6;++ix) {
        stringstream ss;
        ss << "TMP/n" << ix;
        book(_nMeson[ix], ss.str());
      }

    }

    void findChildren(const Particle & p,map<long,int> & nRes, int &ncount) {
      for (const Particle &child : p.children()) {
        if(child.children().empty()) {
          nRes[child.pid()]-=1;
          --ncount;
        }
        else
          findChildren(child,nRes,ncount);
      }
    }

    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& fs = apply<FinalState>(event, "FS");

      map<long,int> nCount;
      int ntotal(0);
      for (const Particle& p : fs.particles()) {
        nCount[p.pid()] += 1;
        ++ntotal;
      }
      const FinalState& ufs = apply<FinalState>(event, "UFS");
      for (const Particle& p : ufs.particles(Cuts::pid==221 or Cuts::pid==333)) {
        if(p.children().empty()) continue;
        map<long,int> nRes = nCount;
        int ncount = ntotal;
        findChildren(p,nRes,ncount);

        if(p.pid()==221) {
          bool matchedKK = false;
          if(ncount==2) {
            matchedKK = true;
            for(auto const & val : nRes) {
              if(abs(val.first)==321) {
                if(val.second!=1) {
                  matchedKK = false;
                  break;
                }
              }
              else if(val.second!=0) {
                matchedKK = false;
                break;
              }
            }
          }
          if(matchedKK) _nMeson[4]->fill();
          for (const Particle& p2 : ufs.particles()) {
            if(p2.pid()!=333) continue;
            if(p2.parents()[0].isSame(p)) continue;
            map<long,int> nResB = nRes;
            int ncountB = ncount;
            findChildren(p2,nResB,ncountB);
            if(ncountB!=0) continue;
            bool matched2 = true;
            for(auto const & val : nResB) {
              if(val.second!=0) {
                matched2 = false;
                break;
              }
            }
            if(matched2) {
              _nMeson[5]->fill();
              break;
            }
          }
        }
        else if(p.pid()==333) {
          if(ncount!=1) continue;
          bool matched = true;
          for(auto const & val : nRes) {
            if(val.first==111) {
              if(val.second!=1) {
                matched = false;
                break;
              }
            }
            else if(val.second!=0) {
              matched = false;
              break;
            }
          }
          if(matched)
            _nMeson[3]->fill();
        }
      }


      if(ntotal==3 && nCount[310]==1 &&
         ((nCount[ 211]==1&&nCount[-321]==1)||
          (nCount[-211]==1&&nCount[ 321]==1)))
        _nMeson[1]->fill();
      else if(ntotal==3 && nCount[321]==1 &&
              nCount[-321]==1 && nCount[111]==1)
        _nMeson[2]->fill();
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      for(unsigned int ix=1;ix<6;++ix) {
        double sigma = _nMeson[ix]->val();
        double error = _nMeson[ix]->err();
        sigma *= crossSection()/ sumOfWeights() /nanobarn;
        error *= crossSection()/ sumOfWeights() /nanobarn;
        Estimate1DPtr  mult;
        book(mult, ix, 1, 1);
        for (auto& b : mult->bins()) {
          if (inRange(sqrtS()/GeV, b.xMin(), b.xMax())) {
            b.set(sigma, error);
          }
        }
      }
    }

    /// @}


    /// @name Histograms
    /// @{
    CounterPtr _nMeson[6];
    /// @}


  };


  RIVET_DECLARE_PLUGIN(BABAR_2008_I765258);

}
