When you want to show your users and contributors that they can use Pixi in your repo, you can use the following badge:

[![Pixi Badge](https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/prefix-dev/pixi/main/assets/badge/v0.json)](https://pixi.sh)

```
[![Pixi Badge](https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/prefix-dev/pixi/main/assets/badge/v0.json)](https://pixi.sh)
```

!!!tip "Customize your badge"
    To further customize the look and feel of your badge,
    you can add `&style=<custom-style>` at the end of the URL.
    See [the documentation on shields.io](https://shields.io/badges/endpoint-badge) for more info.

## Built using Pixi

- Deltares:
  - [Ribasim](https://github.com/Deltares/Ribasim): Water resources model
  - [Ribasim-NL](https://github.com/Deltares/Ribasim-NL): Ribasim water resources modeling in the Netherlands
  - [iMOD Python](https://github.com/Deltares/imod-python): Make massive MODFLOW models
  - [iMOD Coupler](https://github.com/Deltares/imod_coupler): Application for coupling hydrological kernels
  - [iMOD Documentation](https://github.com/Deltares/iMOD-Documentation): Documentation of the iMOD suite.
  - [Xugrid](https://github.com/Deltares/xugrid): Xarray and unstructured grids
  - [Numba celltree](https://github.com/Deltares/numba_celltree): Celltree data structure for searching for points, lines, boxes, and cells (convex polygons) in a two dimensional unstructured mesh.
  - [QGIS-Tim](https://github.com/Deltares/QGIS-Tim): QGIS plugin and utilities for TimML multi-layer analytic element model
  - [Pandamesh](https://github.com/Deltares/pandamesh): From geodataframe to mesh
  - [Wflow](https://github.com/Deltares/Wflow.jl): Hydrological modeling framework
  - [HydroMT](https://github.com/Deltares/hydromt): Automated and reproducible model building and analysis
  - [HydroMT SFINCS](https://github.com/Deltares/hydromt_sfincs): SFINCS plugin for HydroMT
  - [PyFlwDir](https://github.com/Deltares/pyflwdir): Fast methods to work with hydro- and topography data in pure Python.
- USGS:
  - [MODFLOW 6](https://github.com/MODFLOW-USGS/modflow6): USGS modular hydrological model
- QuantCo:
  - [glum](https://github.com/quantco/glum): High performance Python GLMs with all the features!
  - [tabmat](https://github.com/quantco/tabmat): Efficient matrix representations for working with tabular data
  - [pixi-pack](https://github.com/quantco/pixi-pack): A tool to pack and unpack conda environments created with pixi
  - [polarify](https://github.com/quantco/polarify): Simplifying conditional Polars Expressions with Python 🐍 🐻‍❄️
  - [copier-template-python-open-source](https://github.com/quantco/copier-template-python-open-source): Copier template for python projects using pixi
  - [datajudge](https://github.com/quantco/datajudge): Assessing whether data from database complies with reference information
  - [ndonnx](https://github.com/quantco/ndonnx): ONNX-backed array library that is compliant with the Array API standard
  - [multiregex](https://github.com/quantco/multiregex): Quickly match many regexes against a string
  - [slim-trees](https://github.com/quantco/slim-trees): Pickle your ML models more efficiently for deployment 🚀
  - [sqlcompyre](https://github.com/quantco/sqlcompyre): Compare SQL tables and databases
  - [metalearners](https://github.com/quantco/metalearners): MetaLearners for CATE estimation
  - [tabulardelta](https://github.com/quantco/tabulardelta): Simplify table comparisons
  - [pydiverse.pipedag](https://github.com/pydiverse/pydiverse.pipedag): A library for data pipeline orchestration optimizing high development iteration speed
  - [pydiverse.transform](https://github.com/pydiverse/pydiverse.transform): Pipe based dataframe manipulation library that can also transform data on SQL databases

- [pixi-pycharm](https://github.com/pavelzw/pixi-pycharm): Conda shim for PyCharm that proxies pixi
- [pixi-diff-to-markdown](https://github.com/pavelzw/pixi-diff-to-markdown): Generate markdown summaries from Pixi update
- [jiaxiyang/cpp_project_guideline](https://github.com/jiaxiyang/cpp_project_guideline): Guide the way beginners make their c++ projects.
- [hex-inc/vegafusion](https://github.com/hex-inc/vegafusion): Serverside scaling of Vega and Altair visualizations in Rust, Python, WASM, and Java
- [pablovela5620/arxiv-researcher](https://github.com/pablovela5620/arxiv-researcher): Summarize PDF's and Arixv papers with Langchain and Nougat 🦉
- [HaoZeke/xtsci-dist](https://github.com/HaoZeke/xtsci-dist): Incremental `scipy` port using `xtensor`
- [jslorrma/keyrings.artifacts](https://github.com/jslorrma/keyrings.artifacts): Keyring backend that provides authentication for publishing or consuming Python packages to or from Azure Artifacts feeds within Azure DevOps
- [LFortran](https://github.com/lfortran/lfortran): A modern cross-platform Fortran compiler
- [Rerun](https://www.rerun.io/): Rerun is an SDK for building time aware visualizations of multimodal data.
- [conda-auth](https://github.com/conda-incubator/conda-auth): a conda plugin providing more secure authentication support to conda.
- [py-rattler](https://github.com/conda/rattler/tree/main/py-rattler): Build your own conda environment manager using the python wrapper of our Rattler backend.
- [array-api-extra](https://github.com/data-apis/array-api-extra): Extra array functions built on top of the Python array API standard.
- [marray](https://github.com/mdhaber/marray):
Masked versions of Python array API standard compatible arrays.
- [quantity-array](https://github.com/quantity-dev/quantity-array): Quantities with Python array API standard arrays.
- [Bodo](https://github.com/bodo-ai/bodo):  High-Performance Python Compute Engine for Data and AI.
- [metrology-apis](https://github.com/quantity-dev/metrology-apis): Standardised Metrology APIs in Python.
- [xsf](https://github.com/scipy/xsf): Special function implementations.
- [pyfixest](https://github.com/py-econometrics/pyfixest):  Fast High-Dimensional Fixed Effects Regression in Python following fixest-syntax.
- [geovista](https://github.com/bjlittle/geovista): Cartographic rendering and mesh analytics powered by [PyVista](https://github.com/pyvista/pyvista) 🌍
