---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

# `glab release create`

Create a new GitLab release, or update an existing one.

## Synopsis

Create a new GitLab release for a repository, or
update an existing one. Requires at least the Developer role.

An existing release is updated with the new information you provide.

To create a release from an annotated Git tag:

1. Create the tag locally with Git, and push the tag to GitLab.
2. Run this command.
3. If the Git tag you specify doesn't exist, the command creates a
   release from the latest state of the default branch, and tags it
   with the tag name you specify.

   To override this behavior, use `--ref`. The `ref`
   can be a commit SHA, another tag name, or a branch name.
4. Optional. To fetch the new tag locally after the release, run
   `git fetch --tags origin`.

```plaintext
glab release create <tag> [<files>...] [flags]
```

## Examples

```console
# Create a release interactively
$ glab release create v1.0.1

# Create a release non-interactively by specifying a note
$ glab release create v1.0.1 --notes "bugfix release"

# Use release notes from a file
$ glab release create v1.0.1 -F changelog.md

# Upload a release asset with a display name (type will default to 'other')
$ glab release create v1.0.1 '/path/to/asset.zip#My display label'

# Upload a release asset with a display name and type
$ glab release create v1.0.1 '/path/to/asset.png#My display label#image'

# Upload all assets in a specified folder (types default to 'other')
$ glab release create v1.0.1 ./dist/*

# Upload all tarballs in a specified folder (types default to 'other')
$ glab release create v1.0.1 ./dist/*.tar.gz

# Create a release with assets specified as JSON object
$ glab release create v1.0.1 --assets-links='
  [
    {
      "name": "Asset1",
      "url":"https://<domain>/some/location/1",
      "link_type": "other",
      "direct_asset_path": "path/to/file"
    }
  ]'

# (EXPERIMENTAL) Create a release and publish it to the GitLab CI/CD catalog
# Requires the feature flag `ci_release_cli_catalog_publish_option` to be enabled
# for this project in your GitLab instance. Do NOT run this manually. Use it as part
# of a CI/CD pipeline with the "release" keyword:
#
# - It retrieves components from the current repository by searching for
#   `yml` files within the "templates" directory and its subdirectories.
# - It fails if the feature flag `ci_release_cli_catalog_publish_option`
#   is not enabled for this project in your GitLab instance.

# Components can be defined:

# - In single files ending in `.yml` for each component, like `templates/secret-detection.yml`.
# - In subdirectories containing `template.yml` files as entry points,
#   for components that bundle together multiple related files. For example,
#   `templates/secret-detection/template.yml`.

$ glab release create v1.0.1 --publish-to-catalog

```

## Options

```plaintext
  -a, --assets-links string    JSON string representation of assets links. See documentation for example.
  -m, --milestone strings      The title of each milestone the release is associated with.
  -n, --name string            The release name or title.
      --no-close-milestone     Prevent closing milestones after creating the release.
      --no-update              Prevent updating the existing release.
  -N, --notes string           The release notes or description. Accepts Markdown.
  -F, --notes-file string      Read release notes 'file'. To read from stdin, use '-'.
      --package-name string    The package name, when uploading assets to the generic package release with --use-package-registry. (default "release-assets")
      --publish-to-catalog     (EXPERIMENTAL) Publish the release to the GitLab CI/CD catalog.
  -r, --ref string             If the specified tag doesn't exist, create a release from the ref and tag it with the specified tag name. Accepts a commit SHA, tag name, or branch name.
  -D, --released-at string     ISO 8601 datetime when the release was ready. Defaults to the current datetime.
  -T, --tag-message string     Message to use if creating a new annotated tag.
      --use-package-registry   Upload release assets to the generic package registry of the project. Overrides the GITLAB_RELEASE_ASSETS_USE_PACKAGE_REGISTRY environment variable.
```

## Options inherited from parent commands

```plaintext
  -h, --help              Show help for this command.
  -R, --repo OWNER/REPO   Select another repository. Can use either OWNER/REPO or `GROUP/NAMESPACE/REPO` format. Also accepts full URL or Git URL.
```
