/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.MethodInlinerUtilKt;
import org.jetbrains.kotlin.codegen.optimization.common.InstructionLivenessAnalyzer;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0018\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/DeadCodeEliminationMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "<init>", "()V", "transform", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "shouldRemove", "", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "index", "", "liveness", "", "backend"})
public final class DeadCodeEliminationMethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        boolean[] liveness = new InstructionLivenessAnalyzer(methodNode, false, 2, null).analyze();
        ArrayList<AbstractInsnNode> insnsToRemove = new ArrayList<AbstractInsnNode>();
        AbstractInsnNode[] insns = methodNode.instructions.toArray();
        int n = insns.length;
        for (int i = 0; i < n; ++i) {
            AbstractInsnNode insn = insns[i];
            Intrinsics.checkNotNull((Object)insn);
            if (!this.shouldRemove(insn, i, liveness)) continue;
            insnsToRemove.add(insn);
        }
        MethodInlinerUtilKt.remove(methodNode, (Collection<? extends AbstractInsnNode>)insnsToRemove);
        UtilKt.removeEmptyCatchBlocks(methodNode);
        UtilKt.removeUnusedLocalVariables(methodNode);
    }

    private final boolean shouldRemove(AbstractInsnNode insn, int index, boolean[] liveness) {
        if (!(insn instanceof LineNumberNode)) {
            return !liveness[index];
        }
        AbstractInsnNode finger = insn;
        int fingerIndex = index;
        boolean hasDeadInsn = false;
        while (finger.getNext() != null) {
            ++fingerIndex;
            AbstractInsnNode abstractInsnNode = finger;
            if (abstractInsnNode instanceof LabelNode) continue;
            if (abstractInsnNode instanceof LineNumberNode) {
                if (((LineNumberNode)finger).line == ((LineNumberNode)insn).line) continue;
                return hasDeadInsn;
            }
            if (liveness[fingerIndex]) {
                return false;
            }
            hasDeadInsn = true;
        }
        return true;
    }
}

