/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class GrCastFix
extends ModCommandQuickFix {
    private final PsiType myExpectedType;
    private final boolean mySafe;
    @NotNull
    private final SmartPsiElementPointer<GrExpression> pointer;
    @NotNull
    @IntentionName
    private final String myName;

    public GrCastFix(PsiType expectedType, GrExpression expression) {
        this(expectedType, expression, true);
    }

    public GrCastFix(PsiType expectedType, GrExpression expression, boolean safe) {
        this(expectedType, expression, safe, GroovyBundle.message("intention.name.cast.to.0", expectedType.getPresentableText()));
    }

    public GrCastFix(PsiType expectedType, GrExpression expression, boolean safe, @NotNull @IntentionName String name) {
        if (name == null) {
            GrCastFix.$$$reportNull$$$0(0);
        }
        this.mySafe = safe;
        this.myName = name;
        this.myExpectedType = PsiImplUtil.normalizeWildcardTypeByPosition(expectedType, expression);
        this.pointer = SmartPointerManager.getInstance((Project)expression.getProject()).createSmartPsiElementPointer((PsiElement)expression);
    }

    @NotNull
    public ModCommand perform(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        GrExpression expression;
        if (project == null) {
            GrCastFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            GrCastFix.$$$reportNull$$$0(2);
        }
        if ((expression = (GrExpression)this.pointer.getElement()) == null) {
            ModCommand modCommand = ModCommand.nop();
            if (modCommand == null) {
                GrCastFix.$$$reportNull$$$0(3);
            }
            return modCommand;
        }
        ModCommand modCommand = ModCommand.psiUpdate((PsiElement)expression, e -> {
            if (this.mySafe) {
                GrCastFix.doSafeCast(project, this.myExpectedType, e);
            } else {
                GrCastFix.doCast(project, this.myExpectedType, e);
            }
        });
        if (modCommand == null) {
            GrCastFix.$$$reportNull$$$0(4);
        }
        return modCommand;
    }

    private static void doCast(Project project, PsiType type, GrExpression expr) {
        if (!type.isValid()) {
            return;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        GrTypeCastExpression cast = (GrTypeCastExpression)factory.createExpressionFromText("(String)foo");
        GrTypeElement typeElement = factory.createTypeElement(type);
        GrExpression operand = cast.getOperand();
        if (operand == null) {
            return;
        }
        operand.replaceWithExpression(expr, true);
        cast.getCastTypeElement().replace(typeElement);
        GrExpression replaced = expr.replaceWithExpression(cast, true);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)replaced);
    }

    @ApiStatus.Internal
    public static void doSafeCast(@NotNull Project project, @NotNull PsiType type, @NotNull GrExpression expr) {
        if (project == null) {
            GrCastFix.$$$reportNull$$$0(5);
        }
        if (type == null) {
            GrCastFix.$$$reportNull$$$0(6);
        }
        if (expr == null) {
            GrCastFix.$$$reportNull$$$0(7);
        }
        if (!type.isValid()) {
            return;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        GrSafeCastExpression cast = (GrSafeCastExpression)factory.createExpressionFromText("foo as String");
        GrTypeElement typeElement = factory.createTypeElement(type);
        cast.getOperand().replaceWithExpression(expr, true);
        GrTypeElement castTypeElement = cast.getCastTypeElement();
        if (castTypeElement != null) {
            castTypeElement.replace(typeElement);
        }
        GrExpression replaced = expr.replaceWithExpression(cast, true);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)replaced);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            GrCastFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("intention.family.name.add.cast", new Object[0]);
        if (string == null) {
            GrCastFix.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/assignment/GrCastFix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/assignment/GrCastFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doSafeCast";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 8, 9 -> new IllegalStateException(string);
        };
    }
}

