/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.GenericListeningConnector;
import com.jetbrains.jdi.SharedMemoryAttachingConnector;
import com.jetbrains.jdi.VirtualMachineManagerImpl;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;

public class SharedMemoryListeningConnector
extends GenericListeningConnector {
    static final String ARG_NAME = "name";

    public SharedMemoryListeningConnector() throws ReflectiveOperationException {
        super(SharedMemoryAttachingConnector.createSharedMemoryTransportService());
        this.addStringArgument(ARG_NAME, this.getString("memory_listening.name.label"), this.getString("memory_listening.name"), "", false);
        this.transport = () -> "dt_shmem";
    }

    @Override
    public String startListening(Map<String, ? extends Connector.Argument> args) throws IOException, IllegalConnectorArgumentsException {
        String name = this.argument(ARG_NAME, args).value();
        if (name.length() == 0) {
            assert (this.transportService.getClass().getSimpleName().equals("SharedMemoryTransportService"));
            try {
                Method defaultAddressMethod = this.transportService.getClass().getDeclaredMethod("defaultAddress", new Class[0]);
                defaultAddressMethod.setAccessible(true);
                name = (String)defaultAddressMethod.invoke((Object)this.transportService, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return super.startListening(name, args);
    }

    @Override
    public String name() {
        return VirtualMachineManagerImpl.connectorName("com.jetbrains.jdi.SharedMemoryListen");
    }

    @Override
    public String description() {
        return this.getString("memory_listening.description");
    }
}

