/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl.html;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import jetbrains.coverage.report.CoverageStatistics;
import jetbrains.coverage.report.StatisticsCalculator;
import jetbrains.coverage.report.impl.html.BaseGenerator;
import jetbrains.coverage.report.impl.html.LocalGeneratorPaths;
import jetbrains.coverage.report.impl.html.ModuleInfo;
import jetbrains.coverage.report.impl.html.SortOption;
import jetbrains.coverage.report.impl.html.TemplateProcessor;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespacesIndexGenerator
extends BaseGenerator {
    public NamespacesIndexGenerator(@NotNull TemplateProcessor templateFactory, @NotNull LocalGeneratorPaths paths) {
        super(templateFactory, paths);
    }

    public void generateNamespacesIndex(ModuleInfo module, Collection<String> namespaces, StatisticsCalculator covStatsCalculator) throws IOException {
        for (SortOption sortOption : this.getGenerateSortOptions(covStatsCalculator)) {
            HashMap<String, Object> templateModel = new HashMap<String, Object>();
            templateModel.put("module", module);
            templateModel.put("namespaces", this.prepareNamespaces(module, namespaces, covStatsCalculator, sortOption));
            templateModel.put("statsCalculator", covStatsCalculator);
            templateModel.put("sortOption", (Object)sortOption);
            this.myTemplateFactory.renderTemplate(templateModel, this.myPaths.getNamespacesIndexPath(module, sortOption));
        }
    }

    private List<String> prepareNamespaces(ModuleInfo module, Collection<String> namespaces, StatisticsCalculator covStatsCalculator, SortOption sortOption) {
        List<String> result = this.removeNamespacesWithoutStatistics(module, namespaces, covStatsCalculator);
        Collections.sort(result, sortOption.createNamespaceComparator(module, covStatsCalculator));
        return result;
    }

    private List<String> removeNamespacesWithoutStatistics(final @NotNull ModuleInfo module, @NotNull Collection<String> namespaces, final @NotNull StatisticsCalculator covStatsCalculator) {
        return this.filterCovered(namespaces, new BaseGenerator.Converter<String>(){

            @Override
            @NotNull
            public CoverageStatistics convert(String s) {
                return covStatsCalculator.getForNamespace(module.getName(), s);
            }
        });
    }
}

