/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sa.jdwp;

import com.jetbrains.sa.jdi.ArrayReferenceImpl;
import com.jetbrains.sa.jdi.ClassLoaderReferenceImpl;
import com.jetbrains.sa.jdi.ClassObjectReferenceImpl;
import com.jetbrains.sa.jdi.ClassTypeImpl;
import com.jetbrains.sa.jdi.InterfaceTypeImpl;
import com.jetbrains.sa.jdi.LocationImpl;
import com.jetbrains.sa.jdi.ObjectReferenceImpl;
import com.jetbrains.sa.jdi.ReferenceTypeImpl;
import com.jetbrains.sa.jdi.ThreadGroupReferenceImpl;
import com.jetbrains.sa.jdi.ThreadReferenceImpl;
import com.jetbrains.sa.jdi.ValueImpl;
import com.jetbrains.sa.jdwp.Packet;
import com.jetbrains.sa.jdwp.VirtualMachineImpl;
import com.sun.jdi.InternalException;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class PacketStream {
    final VirtualMachineImpl vm;
    private int inCursor = 0;
    final Packet pkt;
    ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
    private boolean isCommitted = false;

    PacketStream(VirtualMachineImpl vm, int id, int cmdSet, int cmd) {
        this.vm = vm;
        this.pkt = new Packet();
        this.pkt.id = id;
        this.pkt.cmdSet = (short)cmdSet;
        this.pkt.cmd = (short)cmd;
    }

    PacketStream(VirtualMachineImpl vm, Packet pkt) {
        this.vm = vm;
        this.pkt = pkt;
        this.isCommitted = true;
    }

    int id() {
        return this.pkt.id;
    }

    void send() {
        if (!this.isCommitted) {
            this.pkt.data = this.dataStream.toByteArray();
            this.vm.sendToTarget(this.pkt);
            this.isCommitted = true;
        }
    }

    public void writeBoolean(boolean data) {
        if (data) {
            this.dataStream.write(1);
        } else {
            this.dataStream.write(0);
        }
    }

    public void writeByte(byte data) {
        this.dataStream.write(data);
    }

    public void writeChar(char data) {
        this.dataStream.write((byte)(data >>> 8 & 0xFF));
        this.dataStream.write((byte)(data >>> 0 & 0xFF));
    }

    public void writeShort(short data) {
        this.dataStream.write((byte)(data >>> 8 & 0xFF));
        this.dataStream.write((byte)(data >>> 0 & 0xFF));
    }

    public void writeInt(int data) {
        this.dataStream.write((byte)(data >>> 24 & 0xFF));
        this.dataStream.write((byte)(data >>> 16 & 0xFF));
        this.dataStream.write((byte)(data >>> 8 & 0xFF));
        this.dataStream.write((byte)(data >>> 0 & 0xFF));
    }

    public void writeLong(long data) {
        this.dataStream.write((byte)(data >>> 56 & 0xFFL));
        this.dataStream.write((byte)(data >>> 48 & 0xFFL));
        this.dataStream.write((byte)(data >>> 40 & 0xFFL));
        this.dataStream.write((byte)(data >>> 32 & 0xFFL));
        this.dataStream.write((byte)(data >>> 24 & 0xFFL));
        this.dataStream.write((byte)(data >>> 16 & 0xFFL));
        this.dataStream.write((byte)(data >>> 8 & 0xFFL));
        this.dataStream.write((byte)(data >>> 0 & 0xFFL));
    }

    public void writeFloat(float data) {
        this.writeInt(Float.floatToIntBits(data));
    }

    public void writeDouble(double data) {
        this.writeLong(Double.doubleToLongBits(data));
    }

    void writeID(int size, long data) {
        switch (size) {
            case 8: {
                this.writeLong(data);
                break;
            }
            case 4: {
                this.writeInt((int)data);
                break;
            }
            case 2: {
                this.writeShort((short)data);
                break;
            }
            default: {
                throw new UnsupportedOperationException("JDWP: ID size not supported: " + size);
            }
        }
    }

    void writeNullObjectRef() {
        this.writeObjectRef(0L);
    }

    public void writeObjectRef(long data) {
        this.writeID(this.vm.sizeofObjectRef, data);
    }

    void writeClassRef(long data) {
        this.writeID(this.vm.sizeofClassRef, data);
    }

    void writeMethodRef(long data) {
        this.writeID(this.vm.sizeofMethodRef, data);
    }

    void writeFieldRef(long data) {
        this.writeID(this.vm.sizeofFieldRef, data);
    }

    void writeFrameRef(long data) {
        this.writeID(this.vm.sizeofFrameRef, data);
    }

    void writeByteArray(byte[] data) {
        this.dataStream.write(data, 0, data.length);
    }

    void writeStringOrEmpty(String string) {
        if (string == null) {
            string = "";
        }
        this.writeString(string);
    }

    void writeString(String string) {
        try {
            byte[] stringBytes = string.getBytes("UTF8");
            this.writeInt(stringBytes.length);
            this.writeByteArray(stringBytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalException("Cannot convert string to UTF8 bytes");
        }
    }

    void writeLocation(LocationImpl location) {
        byte tag;
        ReferenceTypeImpl refType = location.declaringType();
        if (refType instanceof ClassTypeImpl) {
            tag = 1;
        } else if (refType instanceof InterfaceTypeImpl) {
            tag = 2;
        } else {
            throw new InternalException("Invalid Location");
        }
        this.writeByte(tag);
        this.writeClassRef(refType.uniqueID());
        this.writeMethodRef(location.methodRef());
        this.writeLong(location.codeIndexInt());
    }

    void writeValue(ValueImpl val) {
        this.writeValueChecked(val);
    }

    void writeValueChecked(ValueImpl val) {
        this.writeByte(ValueImpl.typeValueKey(val));
        this.writeUntaggedValue(val);
    }

    void writeUntaggedValue(ValueImpl val) {
        this.writeUntaggedValueChecked(val);
    }

    void writeUntaggedValueChecked(ValueImpl val) {
        if (val == null) {
            this.writeNullObjectRef();
        } else {
            val.writeUntaggedValue(this);
        }
    }

    byte readByte() {
        byte ret = this.pkt.data[this.inCursor];
        ++this.inCursor;
        return ret;
    }

    boolean readBoolean() {
        byte ret = this.readByte();
        return ret != 0;
    }

    char readChar() {
        int b1 = this.pkt.data[this.inCursor++] & 0xFF;
        int b2 = this.pkt.data[this.inCursor++] & 0xFF;
        return (char)((b1 << 8) + b2);
    }

    short readShort() {
        int b1 = this.pkt.data[this.inCursor++] & 0xFF;
        int b2 = this.pkt.data[this.inCursor++] & 0xFF;
        return (short)((b1 << 8) + b2);
    }

    int readInt() {
        int b1 = this.pkt.data[this.inCursor++] & 0xFF;
        int b2 = this.pkt.data[this.inCursor++] & 0xFF;
        int b3 = this.pkt.data[this.inCursor++] & 0xFF;
        int b4 = this.pkt.data[this.inCursor++] & 0xFF;
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    long readLong() {
        long b1 = this.pkt.data[this.inCursor++] & 0xFF;
        long b2 = this.pkt.data[this.inCursor++] & 0xFF;
        long b3 = this.pkt.data[this.inCursor++] & 0xFF;
        long b4 = this.pkt.data[this.inCursor++] & 0xFF;
        long b5 = this.pkt.data[this.inCursor++] & 0xFF;
        long b6 = this.pkt.data[this.inCursor++] & 0xFF;
        long b7 = this.pkt.data[this.inCursor++] & 0xFF;
        long b8 = this.pkt.data[this.inCursor++] & 0xFF;
        return (b1 << 56) + (b2 << 48) + (b3 << 40) + (b4 << 32) + (b5 << 24) + (b6 << 16) + (b7 << 8) + b8;
    }

    float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    String readString() {
        String ret;
        int len = this.readInt();
        try {
            ret = new String(this.pkt.data, this.inCursor, len, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e);
            ret = "Conversion error!";
        }
        this.inCursor += len;
        return ret;
    }

    private long readID(int size) {
        switch (size) {
            case 8: {
                return this.readLong();
            }
            case 4: {
                return this.readInt();
            }
            case 2: {
                return this.readShort();
            }
        }
        throw new UnsupportedOperationException("JDWP: ID size not supported: " + size);
    }

    long readObjectRef() {
        return this.readID(this.vm.sizeofObjectRef);
    }

    long readClassRef() {
        return this.readID(this.vm.sizeofClassRef);
    }

    void writeTaggedObjectReference(ObjectReferenceImpl ref) {
        this.writeByte(ValueImpl.typeValueKey(ref));
        this.writeUntaggedObjectReference(ref);
    }

    private void writeUntaggedObjectReference(ObjectReferenceImpl ref) {
        if (ref == null) {
            this.writeNullObjectRef();
        } else {
            this.writeObjectRef(ref.uniqueID());
        }
    }

    ObjectReferenceImpl readObjectReference() {
        return this.vm.vm.objectMirror(this.readObjectRef());
    }

    public ArrayReferenceImpl readArrayReference() {
        long ref = this.readObjectRef();
        return (ArrayReferenceImpl)this.vm.vm.objectMirror(ref);
    }

    ThreadReferenceImpl readThreadReference() {
        return this.vm.vm.getThreadById(this.readObjectRef());
    }

    void writeThreadReference(ThreadReferenceImpl thread) {
        this.writeUntaggedObjectReference(thread);
    }

    ThreadGroupReferenceImpl readThreadGroupReference() {
        long ref = this.readObjectRef();
        return this.vm.vm.getThreadGroupReferenceById(ref);
    }

    void writeThreadGroupReference(ThreadGroupReferenceImpl ref) {
        this.writeUntaggedObjectReference(ref);
    }

    ClassLoaderReferenceImpl readClassLoaderReference() {
        long ref = this.readObjectRef();
        return (ClassLoaderReferenceImpl)this.vm.vm.objectMirror(ref);
    }

    ClassObjectReferenceImpl readClassObjectReference() {
        long ref = this.readObjectRef();
        return (ClassObjectReferenceImpl)this.vm.vm.objectMirror(ref);
    }

    ReferenceTypeImpl readReferenceType() {
        long ref = this.readObjectRef();
        return this.vm.vm.getReferenceTypeById(ref);
    }

    void writeClassLoaderReference(ClassLoaderReferenceImpl ref) {
        this.writeUntaggedObjectReference(ref);
    }

    void writeClassObjectReference(ClassObjectReferenceImpl ref) {
        this.writeObjectRef(ref.uniqueID());
    }

    long readMethodRef() {
        return this.readID(this.vm.sizeofMethodRef);
    }

    long readFieldRef() {
        return this.readID(this.vm.sizeofFieldRef);
    }

    long readFrameRef() {
        return this.readID(this.vm.sizeofFrameRef);
    }

    byte[] readByteArray(int length) {
        byte[] array = new byte[length];
        System.arraycopy(this.pkt.data, this.inCursor, array, 0, length);
        this.inCursor += length;
        return array;
    }

    void writeArrayRegion(List<ValueImpl> srcValues, byte typeTag) {
        this.writeByte(typeTag);
        this.writeInt(srcValues.size());
        boolean withTags = PacketStream.isObjectTag(typeTag);
        for (ValueImpl value : srcValues) {
            if (withTags) {
                this.writeValue(value);
                continue;
            }
            this.writeUntaggedValue(value);
        }
    }

    static boolean isObjectTag(byte tag) {
        return tag == 76 || tag == 91 || tag == 115 || tag == 116 || tag == 103 || tag == 108 || tag == 99;
    }
}

