/*
 * Decompiled with CFR 0.152.
 */
package javax.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public interface StandardJavaFileManager
extends JavaFileManager {
    @Override
    public boolean isSameFile(FileObject var1, FileObject var2);

    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> var1);

    default public Iterable<? extends JavaFileObject> getJavaFileObjectsFromPaths(Collection<? extends Path> collection) {
        return this.getJavaFileObjectsFromFiles(StandardJavaFileManager.asFiles(collection));
    }

    @Deprecated(since="13")
    default public Iterable<? extends JavaFileObject> getJavaFileObjectsFromPaths(Iterable<? extends Path> iterable) {
        return this.getJavaFileObjectsFromPaths(StandardJavaFileManager.asCollection(iterable));
    }

    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... var1);

    default public Iterable<? extends JavaFileObject> getJavaFileObjects(Path ... pathArray) {
        return this.getJavaFileObjectsFromPaths((Collection<? extends Path>)Arrays.asList(pathArray));
    }

    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> var1);

    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... var1);

    public void setLocation(JavaFileManager.Location var1, Iterable<? extends File> var2) throws IOException;

    default public void setLocationFromPaths(JavaFileManager.Location location, Collection<? extends Path> collection) throws IOException {
        this.setLocation(location, StandardJavaFileManager.asFiles(collection));
    }

    default public void setLocationForModule(JavaFileManager.Location location, String string, Collection<? extends Path> collection) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Iterable<? extends File> getLocation(JavaFileManager.Location var1);

    default public Iterable<? extends Path> getLocationAsPaths(JavaFileManager.Location location) {
        return StandardJavaFileManager.asPaths(this.getLocation(location));
    }

    default public Path asPath(FileObject fileObject) {
        throw new UnsupportedOperationException();
    }

    default public void setPathFactory(PathFactory pathFactory) {
    }

    private static Iterable<Path> asPaths(final Iterable<? extends File> iterable) {
        return () -> new Iterator<Path>(){
            final Iterator<? extends File> iter;
            {
                this.iter = iterable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Path next() {
                return this.iter.next().toPath();
            }
        };
    }

    private static Iterable<File> asFiles(final Iterable<? extends Path> iterable) {
        return () -> new Iterator<File>(){
            final Iterator<? extends Path> iter;
            {
                this.iter = iterable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public File next() {
                Path path = this.iter.next();
                try {
                    return path.toFile();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    throw new IllegalArgumentException(path.toString(), unsupportedOperationException);
                }
            }
        };
    }

    private static <T> Collection<T> asCollection(Iterable<T> iterable) {
        if (iterable instanceof Collection) {
            return (Collection)iterable;
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : iterable) {
            arrayList.add(t);
        }
        return arrayList;
    }

    public static interface PathFactory {
        public Path getPath(String var1, String ... var2);
    }
}

