#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Copyright 2023 Mike Fährmann
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation.

"""Generate a document listing gallery-dl's command-line arguments"""

import os
import re
import sys

import util

import gallery_dl.util
gallery_dl.util.EXECUTABLE = True
from gallery_dl import option  # noqa E402


class Formatter(option.Formatter):
    def __init__(self, prog):
        option.argparse.HelpFormatter.__init__(
            self, prog, max_help_position=30, width=77)

    def add_usage(self, usage, actions, groups):
        pass


parser = option.build_parser()
parser.formatter_class = Formatter
parser.format_usage = lambda: ""

opts = parser.format_help()
opts = re.sub(r"(?m)^(\w+.*)", "## \\1", opts)  # group names to headings
opts = opts.replace("\n  ", "\n    ")  # indent by 4


SELF = "/".join(os.path.normpath(__file__).split(os.sep)[-2:])
PATH = (sys.argv[1] if len(sys.argv) > 1 else
        util.path("docs", "options.md"))

with util.lazy(PATH) as fp:
    fp.write(f"""# Command-Line Options

<!-- auto-generated by {SELF} -->
{opts[:-1]}""")
