/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.typedGeometry;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.GeometryType;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.LineString;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.MultiLineString;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.MultiPoint;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.MultiPolygon;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Polygon;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 \u0017*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0017B?\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\b\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Geometry;", "TypeT", "", "type", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/GeometryType;", "myMultiPoint", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiPoint;", "myMultiLineString", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiLineString;", "myMultiPolygon", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiPolygon;", "(Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/GeometryType;Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiPoint;Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiLineString;Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiPolygon;)V", "multiLineString", "getMultiLineString", "()Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiLineString;", "multiPoint", "getMultiPoint", "()Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiPoint;", "multiPolygon", "getMultiPolygon", "()Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiPolygon;", "getType", "()Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/GeometryType;", "Companion", "commons"})
public final class Geometry<TypeT> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GeometryType type;
    @Nullable
    private final MultiPoint<TypeT> myMultiPoint;
    @Nullable
    private final MultiLineString<TypeT> myMultiLineString;
    @Nullable
    private final MultiPolygon<TypeT> myMultiPolygon;

    private Geometry(GeometryType type, MultiPoint<TypeT> myMultiPoint, MultiLineString<TypeT> myMultiLineString, MultiPolygon<TypeT> myMultiPolygon) {
        this.type = type;
        this.myMultiPoint = myMultiPoint;
        this.myMultiLineString = myMultiLineString;
        this.myMultiPolygon = myMultiPolygon;
    }

    @NotNull
    public final GeometryType getType() {
        return this.type;
    }

    @NotNull
    public final MultiPoint<TypeT> getMultiPoint() {
        MultiPoint<TypeT> multiPoint = this.myMultiPoint;
        if (multiPoint == null) {
            throw new IllegalStateException(((Object)((Object)this.type) + " is not a MultiPoint").toString());
        }
        return multiPoint;
    }

    @NotNull
    public final MultiLineString<TypeT> getMultiLineString() {
        MultiLineString<TypeT> multiLineString = this.myMultiLineString;
        if (multiLineString == null) {
            throw new IllegalStateException(((Object)((Object)this.type) + " is not a MultiLineString").toString());
        }
        return multiLineString;
    }

    @NotNull
    public final MultiPolygon<TypeT> getMultiPolygon() {
        MultiPolygon<TypeT> multiPolygon = this.myMultiPolygon;
        if (multiPolygon == null) {
            throw new IllegalStateException(((Object)((Object)this.type) + " is not a MultiPolygon").toString());
        }
        return multiPolygon;
    }

    public /* synthetic */ Geometry(GeometryType type, MultiPoint myMultiPoint, MultiLineString myMultiLineString, MultiPolygon myMultiPolygon, DefaultConstructorMarker $constructor_marker) {
        this(type, myMultiPoint, myMultiLineString, myMultiPolygon);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007J \u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\tJ \u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000bJ \u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00050\rJ \u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000fJ \u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Geometry$Companion;", "", "()V", "of", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Geometry;", "TypeT", "lineString", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/LineString;", "multiLineString", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiLineString;", "multiPoint", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiPoint;", "multiPolygon", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiPolygon;", "polygon", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Polygon;", "point", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "commons"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <TypeT> Geometry<TypeT> of(@NotNull Vec<TypeT> point) {
            Intrinsics.checkNotNullParameter(point, (String)"point");
            return this.of(new MultiPoint<TypeT>(point));
        }

        @NotNull
        public final <TypeT> Geometry<TypeT> of(@NotNull MultiPoint<TypeT> multiPoint) {
            Intrinsics.checkNotNullParameter(multiPoint, (String)"multiPoint");
            return new Geometry(GeometryType.MULTI_POINT, multiPoint, null, null, null);
        }

        @NotNull
        public final <TypeT> Geometry<TypeT> of(@NotNull LineString<TypeT> lineString) {
            Intrinsics.checkNotNullParameter(lineString, (String)"lineString");
            return this.of(new MultiLineString<TypeT>(lineString));
        }

        @NotNull
        public final <TypeT> Geometry<TypeT> of(@NotNull MultiLineString<TypeT> multiLineString) {
            Intrinsics.checkNotNullParameter(multiLineString, (String)"multiLineString");
            return new Geometry(GeometryType.MULTI_LINESTRING, null, multiLineString, null, null);
        }

        @NotNull
        public final <TypeT> Geometry<TypeT> of(@NotNull Polygon<TypeT> polygon2) {
            Intrinsics.checkNotNullParameter(polygon2, (String)"polygon");
            return this.of(new MultiPolygon<TypeT>(polygon2));
        }

        @NotNull
        public final <TypeT> Geometry<TypeT> of(@NotNull MultiPolygon<TypeT> multiPolygon) {
            Intrinsics.checkNotNullParameter(multiPolygon, (String)"multiPolygon");
            return new Geometry(GeometryType.MULTI_POLYGON, null, null, multiPolygon, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

