use crate::{faker::impls::address::CityNameGenFn, locales::Data};

#[allow(non_camel_case_types)]
#[derive(Copy, Clone)]
pub struct PT_BR;

impl Data for PT_BR {
    const NAME_FIRST_NAME: &'static [&'static str] = &[
        "Aaron",
        "Abgail",
        "Adriana",
        "Adriano",
        "Adriel",
        "Adriele",
        "Afonso",
        "Agatha",
        "Agostinho",
        "Agustina",
        "Alan",
        "Alana",
        "Alessandra",
        "Alessandro",
        "Alexa",
        "Alexandre",
        "Alice",
        "Aline",
        "Allan",
        "Allison",
        "Alma",
        "Alonso",
        "Alícia",
        "Amanda",
        "Amélia",
        "Ana",
        "Analu",
        "Anderson",
        "Andres",
        "Andressa",
        "André",
        "Andréa",
        "Andréia",
        "Angélica",
        "Anita",
        "Antonella",
        "Antonieta",
        "Antônio",
        "Aparecida",
        "Ariana",
        "Ariane",
        "Arthur",
        "Artur",
        "Augusto",
        "Aurora",
        "Ayla",
        "Beatriz",
        "Bella",
        "Benedito",
        "Benjamin",
        "Benício",
        "Bernardo",
        "Betina",
        "Bia",
        "Bianca",
        "Breno",
        "Bruna",
        "Bruno",
        "Bárbara",
        "Caio",
        "Camila",
        "Camilo",
        "Carla",
        "Carlos",
        "Carol",
        "Carolina",
        "Caroline",
        "Catarina",
        "Cauan",
        "Cecília",
        "Cezar",
        "Christian",
        "Christopher",
        "Clara",
        "Clarice",
        "Cláudia",
        "Cláudio",
        "Cléber",
        "Constância",
        "Cristian",
        "Cristiana",
        "Cristiano",
        "Cristina",
        "Cristóvão",
        "Cynthia",
        "César",
        "Cíntia",
        "Daiana",
        "Daiane",
        "Daniel",
        "Daniela",
        "Daniele",
        "Daniella",
        "Danielle",
        "Danilo",
        "Dante",
        "Davi",
        "David",
        "Dayana",
        "Dayane",
        "Deivid",
        "Demian",
        "Dener",
        "Denis",
        "Denise",
        "Diana",
        "Diego",
        "Diogo",
        "Dirce",
        "Débora",
        "Edilson",
        "Edson",
        "Eduarda",
        "Eduardo",
        "Elaine",
        "Eliane",
        "Elias",
        "Elis",
        "Elisa",
        "Elizabeth",
        "Ellen",
        "Eloah",
        "Eloá",
        "Emanuel",
        "Emanuelly",
        "Emerson",
        "Emiliano",
        "Emilly",
        "Emily",
        "Emília",
        "Emílio",
        "Enzo",
        "Eric",
        "Erik",
        "Estela",
        "Ester",
        "Esther",
        "Estêvão",
        "Eunice",
        "Eva",
        "Evandro",
        "Everton",
        "Fabiana",
        "Fabiano",
        "Fabrício",
        "Felipe",
        "Fernanda",
        "Fernando",
        "Filipe",
        "Flor",
        "Flávia",
        "Flávio",
        "Franciele",
        "Francisco",
        "Franco",
        "Fábio",
        "Fátima",
        "Gabi",
        "Gabriel",
        "Gabriela",
        "Gabrielle",
        "Gabrielly",
        "Gael",
        "Gean",
        "George",
        "Gian",
        "Gilberto",
        "Giovana",
        "Giovane",
        "Giovanna",
        "Gisela",
        "Gisele",
        "Graziela",
        "Guilherme",
        "Gustavo",
        "Heitor",
        "Helena",
        "Heloise",
        "Heloísa",
        "Henrique",
        "Hernani",
        "Hortência",
        "Horácio",
        "Hosana",
        "Hugo",
        "Ian",
        "Iasmin",
        "Ícaro",
        "Igor",
        "Ingrid",
        "Inácio",
        "Irene",
        "Isaac",
        "Isabel",
        "Isabella",
        "Isabelly",
        "Isadora",
        "Isis",
        "Ivan",
        "Ítalo",
        "Ivana",
        "James",
        "Janaina",
        "Jaqueline",
        "Jasmin",
        "Jean",
        "Jefferson",
        "Jennifer",
        "Jerônimo",
        "Joana",
        "Joaquim",
        "Joaquin",
        "Jonas",
        "Jorge",
        "Josefina",
        "Josué",
        "José",
        "Joyce",
        "João",
        "Juan",
        "Juliana",
        "Juliane",
        "Juliano",
        "Julieta",
        "Jácomo",
        "Jéssica",
        "Júlia",
        "Júlio",
        "Kamila",
        "Karen",
        "Karina",
        "Karine",
        "Katherine",
        "Kauan",
        "Kelly",
        "Ketlin",
        "Kevin",
        "Kléber",
        "Késia",
        "Laiane",
        "Lara",
        "Larissa",
        "Laura",
        "Lavínia",
        "Laís",
        "Leandro",
        "Leo",
        "Leonardo",
        "Letícia",
        "Lia",
        "Lidiane",
        "Lilian",
        "Liz",
        "Lorena",
        "Lorenzo",
        "Louise",
        "Luan",
        "Luana",
        "Luara",
        "Lucas",
        "Luciana",
        "Luciano",
        "Lucio",
        "Luis",
        "Luiz",
        "Luiza",
        "Luna",
        "Luzia",
        "Luísa",
        "Léia",
        "Lívia",
        "Lúcia",
        "Madalena",
        "Maiara",
        "Maicon",
        "Maitê",
        "Malena",
        "Malu",
        "Manoela",
        "Manuel",
        "Manuela",
        "Maraisa",
        "Marcelo",
        "Marco",
        "Marcos",
        "Mari",
        "Maria",
        "Mariah",
        "Mariana",
        "Marina",
        "Marisa",
        "Marta",
        "Martinho",
        "Mary",
        "Marília",
        "Mateus",
        "Matheus",
        "Matias",
        "Mauro",
        "Maurício",
        "Maximiano",
        "Maya",
        "Mayara",
        "Maísa",
        "Mel",
        "Melina",
        "Melinda",
        "Melissa",
        "Mia",
        "Micaela",
        "Michael",
        "Michele",
        "Michelle",
        "Miguel",
        "Mila",
        "Milena",
        "Milene",
        "Miranda",
        "Mirela",
        "Mirella",
        "Miriam",
        "Moisés",
        "Murilo",
        "Márcia",
        "Márcio",
        "Mário",
        "Máximo",
        "Mônica",
        "Naiara",
        "Naomi",
        "Natal",
        "Natan",
        "Nathalia",
        "Natália",
        "Nayara",
        "Nelson",
        "Nero",
        "Nicolas",
        "Nicole",
        "Noa",
        "Noel",
        "Noelí",
        "Noemi",
        "Norma",
        "Nádia",
        "Ohana",
        "Olga",
        "Olívia",
        "Ornela",
        "Otávio",
        "Pablo",
        "Paloma",
        "Paola",
        "Patrícia",
        "Paula",
        "Paulina",
        "Paulo",
        "Pedro",
        "Pietra",
        "Poliana",
        "Priscila",
        "Pâmela",
        "Pérola",
        "Rafael",
        "Rafaela",
        "Raissa",
        "Raphael",
        "Raquel",
        "Rayane",
        "Raysa",
        "Rebeca",
        "Regiane",
        "Regina",
        "Reinaldo",
        "Renan",
        "Renata",
        "Renato",
        "Ricardo",
        "Richard",
        "Roberta",
        "Roberto",
        "Robson",
        "Rodolfo",
        "Rodrigo",
        "Rogério",
        "Ronaldo",
        "Rosana",
        "Ruth",
        "Sabrina",
        "Samanta",
        "Samara",
        "Samuel",
        "Sandra",
        "Sandro",
        "Santiago",
        "Sara",
        "Sarah",
        "Saulo",
        "Sebastião",
        "Sergio",
        "Sheila",
        "Silvana",
        "Simon",
        "Simone",
        "Simão",
        "Sofia",
        "Sophia",
        "Sophie",
        "Stefany",
        "Stella",
        "Stephanie",
        "Stephany",
        "Suelen",
        "Sueli",
        "Suellen",
        "Suzana",
        "Sérgio",
        "Sônia",
        "Tainara",
        "Talita",
        "Tatiana",
        "Tatiane",
        "Taís",
        "Teobaldo",
        "Tessália",
        "Thales",
        "Thalia",
        "Thalissa",
        "Thalita",
        "Thaís",
        "Thiago",
        "Thomas",
        "Théo",
        "Tiago",
        "Tomás",
        "Tábata",
        "Tâmara",
        "Téo",
        "Valentin",
        "Valentina",
        "Valéria",
        "Vanessa",
        "Verônica",
        "Vicente",
        "Victor",
        "Vinícius",
        "Violeta",
        "Vitor",
        "Vitória",
        "Viviane",
        "Wagner",
        "Walter",
        "Wellington",
        "Wesley",
        "William",
        "Willian",
        "Wilson",
        "Yasmin",
        "Yohanna",
        "Yuri",
        "Ziraldo",
    ];
    const NAME_LAST_NAME: &'static [&'static str] = &[
        "Abreu",
        "Aguiar",
        "Alcantara",
        "Alves",
        "Amaral",
        "Aragão",
        "Aranda",
        "Arruda",
        "Ávila",
        "Assunção",
        "Azevedo",
        "Balestero",
        "Barreto",
        "Barros",
        "Batista",
        "Beltrão",
        "Benez",
        "Benites",
        "Bezerra",
        "Bittencourt",
        "Bonilha",
        "Branco",
        "Brito",
        "Burgos",
        "Caldeira",
        "Camacho",
        "Campos",
        "Carmona",
        "Carrara",
        "Carvalho",
        "Casanova",
        "Cervantes",
        "Chaves",
        "Colaço",
        "Cordeiro",
        "Corona",
        "Correia",
        "Cortês",
        "Cruz",
        "D\"ávila",
        "Delatorre",
        "Delgado",
        "Delvalle",
        "Deverso",
        "Dias",
        "Dominato",
        "Domingues",
        "Duarte",
        "Escobar",
        "Espinoza",
        "Esteves",
        "Estrada",
        "Faria",
        "Faro",
        "Feliciano",
        "Ferminiano",
        "Fernandes",
        "Ferraz",
        "Ferreira",
        "Ferreira",
        "Fidalgo",
        "Flores",
        "Fonseca",
        "Fontes",
        "Franco",
        "Furtado",
        "Galhardo",
        "Galindo",
        "Galvão",
        "Garcia",
        "Gil",
        "Godói",
        "Gomes",
        "Gonçalves",
        "Grego",
        "Guerra",
        "Gusmão",
        "Jimenes",
        "Leal",
        "Leon",
        "Lira",
        "Lourenço",
        "Lovato",
        "Lozano",
        "Lutero",
        "Madeira",
        "Maia",
        "Maldonado",
        "Marin",
        "Marinho",
        "Marques",
        "Martines",
        "Marés",
        "Mascarenhas",
        "Matias",
        "Matos",
        "Medina",
        "Meireles",
        "Mendes",
        "Mendonça",
        "Molina",
        "Montenegro",
        "Neves",
        "Oliveira",
        "Ortega",
        "Ortiz",
        "Pacheco",
        "Padilha",
        "Padrão",
        "Paes",
        "Paz",
        "Pedrosa",
        "Pena",
        "Pereira",
        "Perez",
        "Pontes",
        "Prado",
        "Queirós",
        "Queirós",
        "Quintana",
        "Quintana",
        "Ramires",
        "Ramos",
        "Rangel",
        "Reis",
        "Rezende",
        "Rico",
        "Rios",
        "Rivera",
        "Rocha",
        "Rodrigues",
        "Romero",
        "Roque",
        "Rosa",
        "Saito",
        "Salas",
        "Salazar",
        "Sales",
        "Salgado",
        "Sanches",
        "Sandoval",
        "Santacruz",
        "Santana",
        "Santiago",
        "Santos",
        "Saraiva",
        "Sepúlveda",
        "Serna",
        "Serra",
        "Serrano",
        "Soares",
        "Solano",
        "Soto",
        "Souza",
        "Tamoio",
        "Teles",
        "Toledo",
        "Torres",
        "Uchoa",
        "Urias",
        "Valdez",
        "Vale",
        "Valente",
        "Valentin",
        "Valência",
        "Vasques",
        "Vega",
        "Velasques",
        "Verdara",
        "Verdugo",
        "Vieira",
        "Vila",
        "Zamana",
        "Zambrano",
        "Zaragoça",
        "da Cruz",
        "da Rosa",
        "da Silva",
        "das Dores",
        "das Neves",
        "de Aguiar",
        "de Arruda",
        "de Freitas",
        "de Oliveira",
        "de Souza",
    ];

    const INTERNET_FREE_EMAIL_PROVIDER: &'static [&'static str] = &[
        "bol.com.br",
        "gmail.com.br",
        "hotmail.com.br",
        "ig.com.br",
        "outlook.com.br",
        "terra.com.br",
        "uol.com.br",
        "yahoo.com.br",
    ];

    const PHONE_NUMBER_FORMATS: &'static [&'static str] =
        &["(^#) 2###-####", "(^#) 3###-####", "(^#) 4###-####"];
    const PHONE_CELL_NUMBER_FORMATS: &'static [&'static str] = &["(^#) 9####-####"];

    const TIME_DEFAULT_DATE_FORMAT: &'static str = "[day]/[month]/[year]";
    const TIME_DEFAULT_DATETIME_FORMAT: &'static str =
        "[day]/[month]/[year]T[hour]:[minute]:[second][offset_hour sign:mandatory][offset_minute]";

    const INTERNET_DOMAIN_SUFFIX: &'static [&'static str] =
        &["app.br", "art.br", "com.br", "dev.br", "net.br", "org.br"];

    const ADDRESS_STATE: &'static [&'static str] = &[
        "Acre",
        "Alagoas",
        "Amapá",
        "Amazonas",
        "Bahia",
        "Ceará",
        "Distrito Federal",
        "Espírito Santo",
        "Goiás",
        "Maranhão",
        "Mato Grosso",
        "Mato Grosso do Sul",
        "Minas Gerais",
        "Pará",
        "Paraíba",
        "Paraná",
        "Pernambuco",
        "Piauí",
        "Rio de Janeiro",
        "Rio Grande do Norte",
        "Rio Grande do Sul",
        "Rondônia",
        "Roraima",
        "Santa Catarina",
        "São Paulo",
        "Sergipe",
        "Tocantins",
    ];
    const ADDRESS_STATE_ABBR: &'static [&'static str] = &[
        "AC", "AL", "AP", "AM", "BA", "CE", "DF", "ES", "GO", "MA", "MT", "MS", "MG", "PA", "PB",
        "PR", "PE", "PI", "RJ", "RN", "RS", "RO", "RR", "SC", "SP", "SE", "TO",
    ];

    const ADDRESS_STREET_SUFFIX: &'static [&'static str] =
        &["Av.", "Avenida", "R.", "Rua", "Travessa", "Largo"];
    const ADDRESS_STREET_TPL: &'static str = "{StreetSuffix} {StreetName}";

    const ADDRESS_POSTCODE_FORMATS: &'static [&'static str] = &["#####-###"];
    const COMPANY_SUFFIX: &'static [&'static str] = &["e Filhos", "e Associados", "Ltda.", "S.A."];
}

impl CityNameGenFn for PT_BR {}
