use crate::{faker::impls::address::CityNameGenFn, locales::Data};

#[allow(non_camel_case_types)]
#[derive(Copy, Clone)]
pub struct IT_IT;

impl Data for IT_IT {
    const NAME_FIRST_NAME: &'static [&'static str] = &[
        "Adele",
        "Alessandro",
        "Alessio",
        "Alice",
        "Ambra",
        "Amelia",
        "Andrea",
        "Anita",
        "Anna",
        "Antonio",
        "Arianna",
        "Aurora",
        "Azzurra",
        "Beatrice",
        "Bianca",
        "Camilla",
        "Carlotta",
        "Cecilia",
        "Celeste",
        "Chiara",
        "Chloe",
        "Christian",
        "Damiano",
        "Daniele",
        "Davide",
        "Diana",
        "Diego",
        "Domenico",
        "Edoardo",
        "Elena",
        "Eleonora",
        "Elia",
        "Elisa",
        "Emanuele",
        "Emily",
        "Emma",
        "Enea",
        "Ettore",
        "Eva",
        "Federico",
        "Filippo",
        "Francesca",
        "Francesco",
        "Gabriel",
        "Gabriele",
        "Gaia",
        "Giacomo",
        "Giada",
        "Ginevra",
        "Gioele",
        "Gioia",
        "Giorgia",
        "Giorgio",
        "Giovanni",
        "Giulia",
        "Giulio",
        "Giuseppe",
        "Greta",
        "Isabel",
        "Jacopo",
        "Lavinia",
        "Leonardo",
        "Liam",
        "Lorenzo",
        "Luca",
        "Ludovica",
        "Luigi",
        "Marco",
        "Margherita",
        "Maria",
        "Marta",
        "Martina",
        "Matilde",
        "Matteo",
        "Mattia",
        "Mia",
        "Michele",
        "Nathan",
        "Nicole",
        "Nina",
        "Noah",
        "Noemi",
        "Pietro",
        "Raffaele",
        "Rebecca",
        "Riccardo",
        "Salvatore",
        "Samuel",
        "Samuele",
        "Santiago",
        "Sara",
        "Simone",
        "Sofia",
        "Sole",
        "Thomas",
        "Tommaso",
        "Vincenzo",
        "Viola",
        "Vittoria",
    ];

    const NAME_LAST_NAME: &'static [&'static str] = &[
        "Barbieri",
        "Bianchi",
        "Bianco",
        "Bruno",
        "Caruso",
        "Cattaneo",
        "Colombo",
        "Conti",
        "Coppola",
        "Costa",
        "D'Angelo",
        "Dalla",
        "De Luca",
        "Esposito",
        "Fabbri",
        "Ferrara",
        "Ferrari",
        "Ferri",
        "Fontana",
        "Galli",
        "Gallo",
        "Gatti",
        "Gentile",
        "Giordano",
        "Greco",
        "Leone",
        "Lombardi",
        "Longo",
        "Mancini",
        "Marchetti",
        "Mariani",
        "Marini",
        "Marino",
        "Martinelli",
        "Martini",
        "Messina",
        "Monti",
        "Moretti",
        "Ricci	",
        "Rinaldi",
        "Rizzo",
        "Romano",
        "Rossi",
        "Russo",
        "Sala",
        "Santoro",
        "Serra",
        "Villa",
        "Vitale",
    ];

    const INTERNET_FREE_EMAIL_PROVIDER: &'static [&'static str] = &[
        "email.it",
        "gmail.com",
        "hotmail.com",
        "icloud.com",
        "libero.it",
        "live.com",
        "outlook.com",
        "virgilio.it",
        "yahoo.com",
    ];
    const INTERNET_DOMAIN_SUFFIX: &'static [&'static str] = &["it", "com", "net", "org"];

    const PHONE_NUMBER_FORMATS: &'static [&'static str] = &[
        "+39 0# #######",
        "+39 0## #######",
        "+39 0### #######",
        "+39 3## #######",
    ];
    const PHONE_CELL_NUMBER_FORMATS: &'static [&'static str] = &[
        "+39 32# #######",
        "+39 33# #######",
        "+39 34# #######",
        "+39 36# #######",
        "+39 37# #######",
        "+39 38# #######",
        "+39 39# #######",
    ];

    const CHRONO_DEFAULT_TIME_FORMAT: &'static str = "%H:%M:%S";
    const CHRONO_DEFAULT_DATE_FORMAT: &'static str = "%d-%m-%Y";
    const CHRONO_DEFAULT_DATETIME_FORMAT: &'static str = "%d-%m-%Y %H:%M:%S";

    const TIME_DEFAULT_DATE_FORMAT: &'static str = "[day]-[month]-[year]";
    const TIME_DEFAULT_DATETIME_FORMAT: &'static str =
        "[day]-[month]-[year] [hour]:[minute]:[second]";

    const ADDRESS_BUILDING_NUMBER_FORMATS: &'static [&'static str] = &["nº ###", "nº ##", "nº #"];
    const ADDRESS_CITY_PREFIX: &'static [&'static str] = &["Villa", "San", "Santa", "Santo"];
    const ADDRESS_CITY_SUFFIX: &'static [&'static str] =
        &["del Castello", "del Lago", "del Tramonto"];
    const ADDRESS_COUNTRY: &'static [&'static str] = &[
        "Afghanistan",
        "Albania",
        "Algeria",
        "Andorra",
        "Angola",
        "Anguilla",
        "Antartide",
        "Antigua e Barbuda",
        "Arabia Saudita",
        "Argentina",
        "Armenia",
        "Aruba",
        "Australia",
        "Austria",
        "Azerbaigian",
        "Bahamas",
        "Bahrein",
        "Bangladesh",
        "Barbados",
        "Belgio",
        "Belize",
        "Benin",
        "Bermuda",
        "Bhutan",
        "Bielorussia",
        "Birmania",
        "Bolivia",
        "Bosnia ed Erzegovina",
        "Botswana",
        "Brasile",
        "Brunei",
        "Bulgaria",
        "Burkina Faso",
        "Burundi",
        "Cambogia",
        "Camerun",
        "Canada",
        "Capo Verde",
        "Ciad",
        "Cile",
        "Cina",
        "Cipro",
        "Citt",
        "Colombia",
        "Comore",
        "Corea del Nord",
        "Corea del Sud",
        "Costa Rica",
        "Costa d'Avorio",
        "Croazia",
        "Cuba",
        "Danimarca",
        "Dominica",
        "Ecuador",
        "Egitto",
        "El Salvador",
        "Emirati Arabi Uniti",
        "Eritrea",
        "Estonia",
        "Etiopia",
        "Figi",
        "Filippine",
        "Finlandia",
        "Francia",
        "Gabon",
        "Gambia",
        "Georgia del Sud e isole Sandwich meridionali",
        "Georgia",
        "Germania",
        "Ghana",
        "Giamaica",
        "Giappone",
        "Gibilterra",
        "Gibuti",
        "Giordania",
        "Grecia",
        "Grenada",
        "Groenlandia",
        "Guadalupa",
        "Guam",
        "Guatemala",
        "Guernsey",
        "Guinea Equatoriale",
        "Guinea",
        "Guinea-Bissau",
        "Guyana francese",
        "Guyana",
        "Haiti",
        "Honduras",
        "Hong Kong",
        "India",
        "Indonesia",
        "Iran",
        "Iraq",
        "Irlanda",
        "Islanda",
        "Isola Bouvet",
        "Isola Norfolk",
        "Isola di Man",
        "Isola di Natale",
        "Isole BES",
        "Isole Cayman",
        "Isole Cocos (Keeling)",
        "Isole Cook",
        "Isole Falkland",
        "Isole Heard e McDonald",
        "Isole Marianne Settentrionali",
        "Isole Marshall",
        "Isole Pitcairn",
        "Isole Salomone",
        "Isole Vergini americane",
        "Isole Vergini britanniche",
        "Isole minori esterne degli Stati Uniti",
        "Israele",
        "Italia",
        "Jersey",
        "Kazakistan",
        "Kenya",
        "Kirghizistan",
        "Kiribati",
        "Kuwait",
        "Laos",
        "Lesotho",
        "Lettonia",
        "Libano",
        "Liberia",
        "Libia",
        "Liechtenstein",
        "Lituania",
        "Lussemburgo",
        "Macao",
        "Macedonia",
        "Madagascar",
        "Malawi",
        "Maldive",
        "Malesia",
        "Mali",
        "Malta",
        "Marocco",
        "Martinica",
        "Mauritania",
        "Mauritius",
        "Mayotte",
        "Messico",
        "Micronesia",
        "Moldavia",
        "Monaco",
        "Mongolia",
        "Montenegro",
        "Montserrat",
        "Mozambico",
        "Namibia",
        "Nauru",
        "Nepal",
        "Nicaragua",
        "Niger",
        "Nigeria",
        "Niue",
        "Norvegia",
        "Nuova Caledonia",
        "Nuova Zelanda",
        "Oman",
        "Paesi Bassi",
        "Pakistan",
        "Palau",
        "Palestina",
        "Panam",
        "Papua Nuova Guinea",
        "Paraguay",
        "Perù",
        "Polinesia Francese",
        "Polonia",
        "Porto Rico",
        "Portogallo",
        "Qatar",
        "Repubblica Democratica del Congo",
        "Regno Unito",
        "Repubblica Ceca",
        "Repubblica Centrafricana",
        "Repubblica Dominicana",
        "Repubblica del Congo",
        "Riunione",
        "Romania",
        "Ruanda",
        "Russia",
        "Sahara Occidentale",
        "Saint Kitts e Nevis",
        "Saint Vincent e Grenadine",
        "Saint-Barth",
        "Saint-Martin",
        "Saint-Pierre e Miquelon",
        "Samoa Americane",
        "Samoa",
        "San Marino",
        "Sant'Elena, Ascensione e Tristan da Cunha",
        "Santa Lucia",
        "Senegal",
        "Serbia",
        "Seychelles",
        "Sierra Leone",
        "Singapore",
        "Sint Maarten",
        "Siria",
        "Slovacchia",
        "Slovenia",
        "Somalia",
        "Spagna",
        "Sri Lanka",
        "Stati Uniti D'America",
        "Sudafrica",
        "Sudan del Sud",
        "Sudan",
        "Suriname",
        "Svalbard e Jan Mayen",
        "Svezia",
        "Svizzera",
        "Swaziland",
        "Tagikistan",
        "Taiwan",
        "Tanzania",
        "Terre australi e antartiche francesi",
        "Territorio britannico dell'oceano Indiano",
        "Thailandia",
        "Timor Est",
        "Togo",
        "Tokelau",
        "Tonga",
        "Trinidad e Tobago",
        "Tunisia",
        "Turchia",
        "Turkmenistan",
        "Turks e Caicos",
        "Tuvalu",
        "Ucraina",
        "Uganda",
        "Ungheria",
        "Uruguay",
        "Uzbekistan",
        "Vanuatu",
        "Venezuela",
        "Vietnam",
        "Wallis e Futuna",
        "Yemen",
        "Zambia",
        "Zimbabwe",
    ];
    const ADDRESS_SECONDARY_ADDR_TYPE: &'static [&'static str] =
        &["Appartamento", "Scala", "Interno"];
    const ADDRESS_STATE: &'static [&'static str] = &[
        "AGRIGENTO",
        "ALESSANDRIA",
        "ANCONA",
        "AOSTA",
        "AREZZO",
        "ASCOLI PICENO",
        "ASTI",
        "AVELLINO",
        "BARI",
        "BARLETTA-ANDRIA-TRANI",
        "BELLUNO",
        "BENEVENTO",
        "BERGAMO",
        "BIELLA",
        "BOLOGNA",
        "BOLZANO",
        "BRESCIA",
        "BRINDISI",
        "CAGLIARI",
        "CALTANISSETTA",
        "CAMPOBASSO",
        "CARBONIA-IGLESIAS",
        "CASERTA",
        "CATANIA",
        "CATANZARO",
        "CHIETI",
        "COMO",
        "COSENZA",
        "CREMONA",
        "CROTONE",
        "CUNEO",
        "ENNA",
        "FERMO",
        "FERRARA",
        "FIRENZE",
        "FOGGIA",
        "FORLI’-CESENA",
        "FROSINONE",
        "GENOVA",
        "GORIZIA",
        "GROSSETO",
        "IMPERIA",
        "ISERNIA",
        "LA SPEZIA",
        "L’AQUILA",
        "LATINA",
        "LECCE",
        "LECCO",
        "LIVORNO",
        "LODI",
        "LUCCA",
        "MACERATA",
        "MANTOVA",
        "MASSA-CARRARA",
        "MATERA",
        "MEDIO CAMPIDANO",
        "MESSINA",
        "MILANO",
        "MODENA",
        "MONZA E BRIANZA",
        "NAPOLI",
        "NOVARA",
        "NUORO",
        "OGLIASTRA",
        "OLBIA-TEMPIO",
        "ORISTANO",
        "PADOVA",
        "PALERMO",
        "PARMA",
        "PAVIA",
        "PERUGIA",
        "PESARO E URBINO",
        "PESCARA",
        "PIACENZA",
        "PISA",
        "PISTOIA",
        "PORDENONE",
        "POTENZA",
        "PRATO",
        "RAGUSA",
        "RAVENNA",
        "REGGIO CALABRIA",
        "REGGIO EMILIA",
        "RIETI",
        "RIMINI",
        "ROMA",
        "ROVIGO",
        "SALERNO",
        "SASSARI",
        "SAVONA",
        "SIENA",
        "SIRACUSA",
        "SONDRIO",
        "TARANTO",
        "TERAMO",
        "TERNI",
        "TORINO",
        "TRAPANI",
        "TRENTO",
        "TREVISO",
        "TRIESTE",
        "UDINE",
        "VARESE",
        "VENEZIA",
        "VERBANO-CUSIO-OSSOLA",
        "VERCELLI",
        "VERONA",
        "VIBO VALENTIA",
        "VICENZA",
        "VITERBO",
    ];
    const ADDRESS_STATE_ABBR: &'static [&'static str] = &[
        "AG", "AL", "AN", "AO", "AR", "AP", "AT", "AV", "BA", "BT", "BL", "BN", "BG", "BI", "BO",
        "BZ", "BS", "BR", "CA", "CL", "CB", "CI", "CE", "CT", "CZ", "CH", "CO", "CS", "CR", "KR",
        "CN", "EN", "FM", "FE", "FI", "FG", "FC", "FR", "GE", "GO", "GR", "IM", "IS", "SP", "AQ",
        "LT", "LE", "LC", "LI", "LO", "LU", "MC", "MN", "MS", "MT", "VS", "ME", "MI", "MO", "MB",
        "NA", "NO", "NU", "OG", "OT", "OR", "PD", "PA", "PR", "PV", "PG", "PU", "PE", "PC", "PI",
        "PT", "PN", "PZ", "PO", "RG", "RA", "RC", "RE", "RI", "RN", "RM", "RO", "SA", "SS", "SV",
        "SI", "SR", "SO", "TA", "TE", "TR", "TO", "TP", "TN", "TV", "TS", "UD", "VA", "VE", "VB",
        "VC", "VR", "VV", "VI", "VT",
    ];
    const ADDRESS_STREET_SUFFIX: &'static [&'static str] = &[
        "Via",
        "Viale",
        "Piazza",
        "Piazzale",
        "Corso",
        "Strada",
        "Circonvallazione",
    ];
    const ADDRESS_STREET_TPL: &'static str = "{StreetSuffix} {StreetName}";
    const ADDRESS_TIME_ZONE: &'static [&'static str] = &["Europe/Rome"];
    const ADDRESS_ZIP_FORMATS: &'static [&'static str] = &["#####"];
    const ADDRESS_POSTCODE_FORMATS: &'static [&'static str] = &["#####"];

    const CURRENCY_NAME: &'static [&'static str] = &[
        "Dirham degli Emirati Arabi Uniti",
        "Afghani",
        "Lek albanese",
        "Dram armeno",
        "Fiorino delle Antille olandesi",
        "Kwanza angolano",
        "Peso argentino",
        "Dollaro australiano",
        "Fiorino arubano",
        "Manat azero",
        "Marco bosniaco",
        "Dollaro di Barbados",
        "Taka bengalese",
        "Nuovo lev bulgaro",
        "Dinaro del Bahrein",
        "Franco del Burundi",
        "Dollaro di Bermuda",
        "Dollaro del Brunei",
        "Mvdol Boliviano",
        "Real brasiliano",
        "Dollaro delle Bahamas",
        "Ngultrum del Bhutan",
        "Pula del Botswana",
        "Rublo bielorusso",
        "Dollaro del Belize",
        "Dollaro canadese",
        "Franco congolese",
        "Franco svizzero",
        "Peso cileno",
        "Yuan",
        "Peso colombiano",
        "Colón costaricano",
        "Peso cubano",
        "Escudo capoverdiano",
        "Corona ceca",
        "Franco gibutiano",
        "Corona danese",
        "Peso dominicano",
        "Dinaro algerino",
        "Sterlina egiziana",
        "Nacfa eritreo",
        "Birr etiope",
        "Euro",
        "Dollaro delle Figi",
        "Sterlina delle Falkland",
        "Sterlina britannica",
        "Lari georgiano",
        "Cedi ghanese",
        "Sterlina di Gibilterra",
        "Dalasi gambese",
        "Franco guineano",
        "Quetzal guatemalteco",
        "Dollaro della Guyana",
        "Dollaro di Hong Kong",
        "Lempira honduregna",
        "Gourde haitiano",
        "Fiorino ungherese",
        "Rupia indonesiana",
        "Nuovo shekel israeliano",
        "Rupia indiana",
        "Dinaro iracheno",
        "Riyal iraniano",
        "Corona islandese",
        "Dollaro giamaicano",
        "Dinaro giordano",
        "Yen",
        "Scellino keniota",
        "Som kirghiso",
        "Riel cambogiano",
        "Franco delle Comore",
        "Won nordcoreano",
        "Won sudcoreano",
        "Dinaro kuwaitiano",
        "Dollaro delle Cayman",
        "Tenge kazako",
        "Kip laotiano",
        "Lira libanese",
        "Rupia singalese",
        "Dollaro liberiano",
        "Loti lesothiano",
        "Dinaro libico",
        "Dirham marocchino",
        "Leu moldavo",
        "Ariary malgascio",
        "Dinaro macedone",
        "Kyat birmano",
        "Tugrik mongolo",
        "Pataca di Macao",
        "Ouguiya mauritana",
        "Rupia mauriziana",
        "Rufiyaa delle Maldive",
        "Kwacha malawiano",
        "Peso messicano",
        "Ringgit malaysiano",
        "Metical mozambicano",
        "Dollaro namibiano",
        "Naira nigeriana",
        "Córdoba nicaraguense",
        "Corona norvegese",
        "Rupia nepalese",
        "Dollaro neozelandese",
        "Rial dell'Oman",
        "Balboa panamense",
        "Nuevo Sol peruviano",
        "Kina papuana",
        "Peso filippino",
        "Rupia pakistana",
        "Złoty polacco",
        "Guaraní paraguaiano",
        "Riyal del Qatar",
        "Nuovo leu romeno",
        "Dinaro serbo",
        "Rublo russo",
        "Franco ruandese",
        "Riyal saudita",
        "Dollaro delle Salomone",
        "Rupia delle Seychelles",
        "Sterlina sudanese",
        "Corona svedese",
        "Dollaro di Singapore",
        "Sterlina di Sant'Elena",
        "Leone sierraleonese",
        "Scellino somalo",
        "Dollaro surinamese",
        "Sterlina sudsudanese",
        "Dobra di São Tomé e Príncipe",
        "Lira siriana",
        "Lilangeni dell'eSwatini",
        "Baht thailandese",
        "Somoni tagiko",
        "Manat turkmeno",
        "Dinaro tunisino",
        "Paʻanga tongano",
        "Nuova lira turca",
        "Dollaro di Trinidad e Tobago",
        "Nuovo dollaro taiwanese",
        "Scellino tanzaniano",
        "Grivnia ucraina",
        "Scellino ugandese",
        "Dollaro statunitense",
        "Peso uruguaiano",
        "Som uzbeko",
        "Bolívar venezuelano",
        "Đồng",
        "Vatu",
        "Tālā samoano",
        "Dollaro dei Caraibi Orientali",
        "Riyal yemenita",
        "Rand sudafricano",
        "Kwacha zambiano",
        "Dollaro zimbabwese",
    ];

    const CURRENCY_CODE: &'static [&'static str] = &[
        "AED", "AFN", "ALL", "AMD", "ANG", "AOA", "ARS", "AUD", "AWG", "AZN", "BAM", "BBD", "BDT",
        "BGN", "BHD", "BIF", "BMD", "BND", "BOV", "BRL", "BSD", "BTN", "BWP", "BYN", "BZD", "CAD",
        "CDF", "CHF", "CLP", "CNY", "COP", "CRC", "CUP", "CVE", "CZK", "DJF", "DKK", "DOP", "DZD",
        "EGP", "ERN", "ETB", "EUR", "FJD", "FKP", "GBP", "GEL", "GHS", "GIP", "GMD", "GNF", "GTQ",
        "GYD", "HKD", "HNL", "HTG", "HUF", "IDR", "ILS", "INR", "IQD", "IRR", "ISK", "JMD", "JOD",
        "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR",
        "LRD", "LSL", "LYD", "MAD", "MDL", "MGA", "MKD", "MMK", "MNT", "MOP", "MRO", "MUR", "MVR",
        "MWK", "MXN", "MYR", "MZN", "NAD", "NGN", "NIO", "NOK", "NPR", "NZD", "OMR", "PAB", "PEN",
        "PGK", "PHP", "PKR", "PLN", "PYG", "QAR", "RON", "RSD", "RUB", "RWF", "SAR", "SBD", "SCR",
        "SDG", "SEK", "SGD", "SHP", "SLL", "SOS", "SRD", "SSP", "STD", "SYP", "SZL", "THB", "TJS",
        "TMT", "TND", "TOP", "TRY", "TTD", "TWD", "TZS", "UAH", "UGX", "USD", "UYU", "UZS", "VEF",
        "VND", "VUV", "WST", "XCD", "YER", "ZAR", "ZMW", "ZWL",
    ];

    const CURRENCY_SYMBOL: &'static [&'static str] = &[
        "HK$", "Ft", "₪", "¥", "$", "kr", "PhP", "zł", "CHF", "NT$", "฿", "£", "¢", "Rp", "ƒ", "€",
        "रू",
    ];

    // Add company related constants
    const COMPANY_SUFFIX: &'static [&'static str] = &[
        "S.p.A.", "S.a.p.a.", "S.r.l.", "S.r.ls.", "S.s.", "S.n.c.", "S.a.s.",
    ];

    const NAME_TITLE: &'static [&'static str] = &[
        "Sig.", "Sig.ra", "Dott.", "Dott.ssa", "Prof.", "Prof.sa", "Avv.", "Arch.", "Geom.", "Rag.",
    ];
    const NAME_SUFFIX: &'static [&'static str] = &["Jr.", "Figlio"];
    const NAME_TPL: &'static str = "{FirstName} {LastName}";
    const NAME_WITH_TITLE_TPL: &'static str = "{Title} {FirstName} {LastName}";

    const JOB_SENIORITY: &'static [&'static str] = &["Senior", "Junior", "Capo"];

    const JOB_FIELD: &'static [&'static str] = &[
        "Marketing",
        "Informatica",
        "Contabilità",
        "Amministrazione",
        "Publicità",
        "Finanza",
        "Servizi alla Comunità",
        "Construzioni",
        "Design",
        "Educazione",
        "Agricultura",
        "Governo",
        "Salute",
        "Hotelaria",
        "Giuridico",
        "Industria",
        "Minerario",
        "Immobiliare",
        "Vendite",
        "Tecnologia",
    ];

    const JOB_POSITION: &'static [&'static str] = &[
        "Supervisore",
        "Coordinadore",
        "Ingegnere",
        "Specialista",
        "Direttore",
        "Amministratore",
        "Architetto",
        "Analista",
        "Designer",
        "Tecnico",
        "Analista",
        "Produtore",
        "Consulente",
        "Assistente",
        "Representante",
    ];

    const JOB_TITLE_TPL: &'static str = "{Position} {Seniority} {Field}";

    const ADDRESS_CITY_TPL: &'static str = "{CityName} {CitySuffix}";
    const ADDRESS_CITY_WITH_PREFIX_TPL: &'static str = "{CityPrefix} {CityName} {CitySuffix}";
    const ADDRESS_SECONDARY_ADDR_TPL: &'static str = "{SecondaryAddrType} {Number}";

    const COMPANY_NAME_TPLS: &'static [&'static str] =
        &["{Name_1} {Suffix}", "{Name_1} e {Name_2} {Suffix}"];
    const COMPANY_BUZZWORD_HEAD: &'static [&'static str] = &[
        "Adattabile",
        "Avanzatp",
        "Automatizzatp",
        "Centralizzato",
        "Compatíbile",
        "Configurabile",
        "Digitale",
        "Distribuíto",
        "Diversificato",
        "Esclusivo",
        "Espandibile",
        "Focalizzato",
        "Fundamentale",
        "Inovativo",
        "Integrato",
        "Intuitivo",
        "Ottimizato",
        "Organizato",
        "Progressivo",
        "Robusto",
        "Versatile",
        "Virtuale",
    ];

    const COMPANY_BUZZWORD_MIDDLE: &'static [&'static str] = &[
        "24 ore",
        "globale",
        "digitale",
        "dinamico",
        "empresarial",
        "efficiente",
        "flessíbile",
        "integrato",
        "innovativo",
        "intelligente",
        "mobilr",
        "proattivo",
        "professionale",
        "regionale",
        "responsivo",
        "sostenibile",
        "tecnologico",
    ];

    const COMPANY_BUZZWORD_TAIL: &'static [&'static str] = &[
        "soluzioni",
        "servizi",
        "sistemi",
        "strategie",
        "tecnologie",
        "metodologie",
        "architettura",
        "infrastrutura",
        "applicazioni",
        "interfacce",
        "iniziative",
        "piattaforme",
        "innovazione",
        "paradigma",
        "visione",
    ];

    const COMPANY_CATCH_PHASE_TPL: &'static str = "{Head} {Middle} {Tail}";

    const COMPANY_BS_VERBS: &'static [&'static str] = &[
        "implementare",
        "utilizzare",
        "integrare",
        "ottimizare",
        "evolvere",
        "transformare",
        "innovavare",
        "massimizare",
        "potenziare",
        "espandere",
    ];

    const COMPANY_BS_ADJ: &'static [&'static str] = &[
        "efficienti",
        "proattive",
        "robuste",
        "rivoluzionarie",
        "scalabili",
        "innovative",
        "intuitive",
        "strategiche",
        "integrate",
        "digitali",
        "dinamichr",
        "globali",
    ];

    const COMPANY_BS_NOUNS: &'static [&'static str] = &[
        "sinergie",
        "soluzioni",
        "infrastrutture",
        "piattaforme",
        "iniziative",
        "comunità",
        "tecnologie",
        "metodologie",
    ];

    const COMPANY_BS_TPL: &'static str = "{Verb} {Noun} {Adj}";
}

impl CityNameGenFn for IT_IT {}
