// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The V1 S3 Metadata configuration for a general purpose bucket.</p><note>
/// <p>If you created your S3 Metadata configuration before July 15, 2025, we recommend that you delete and re-create your configuration by using <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucketMetadataConfiguration.html">CreateBucketMetadataConfiguration</a> so that you can expire journal table records and create a live inventory table.</p>
/// </note>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct MetadataTableConfiguration {
    /// <p>The destination information for the metadata table configuration. The destination table bucket must be in the same Region and Amazon Web Services account as the general purpose bucket. The specified metadata table name must be unique within the <code>aws_s3_metadata</code> namespace in the destination table bucket.</p>
    pub s3_tables_destination: ::std::option::Option<crate::types::S3TablesDestination>,
}
impl MetadataTableConfiguration {
    /// <p>The destination information for the metadata table configuration. The destination table bucket must be in the same Region and Amazon Web Services account as the general purpose bucket. The specified metadata table name must be unique within the <code>aws_s3_metadata</code> namespace in the destination table bucket.</p>
    pub fn s3_tables_destination(&self) -> ::std::option::Option<&crate::types::S3TablesDestination> {
        self.s3_tables_destination.as_ref()
    }
}
impl MetadataTableConfiguration {
    /// Creates a new builder-style object to manufacture [`MetadataTableConfiguration`](crate::types::MetadataTableConfiguration).
    pub fn builder() -> crate::types::builders::MetadataTableConfigurationBuilder {
        crate::types::builders::MetadataTableConfigurationBuilder::default()
    }
}

/// A builder for [`MetadataTableConfiguration`](crate::types::MetadataTableConfiguration).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct MetadataTableConfigurationBuilder {
    pub(crate) s3_tables_destination: ::std::option::Option<crate::types::S3TablesDestination>,
}
impl MetadataTableConfigurationBuilder {
    /// <p>The destination information for the metadata table configuration. The destination table bucket must be in the same Region and Amazon Web Services account as the general purpose bucket. The specified metadata table name must be unique within the <code>aws_s3_metadata</code> namespace in the destination table bucket.</p>
    /// This field is required.
    pub fn s3_tables_destination(mut self, input: crate::types::S3TablesDestination) -> Self {
        self.s3_tables_destination = ::std::option::Option::Some(input);
        self
    }
    /// <p>The destination information for the metadata table configuration. The destination table bucket must be in the same Region and Amazon Web Services account as the general purpose bucket. The specified metadata table name must be unique within the <code>aws_s3_metadata</code> namespace in the destination table bucket.</p>
    pub fn set_s3_tables_destination(mut self, input: ::std::option::Option<crate::types::S3TablesDestination>) -> Self {
        self.s3_tables_destination = input;
        self
    }
    /// <p>The destination information for the metadata table configuration. The destination table bucket must be in the same Region and Amazon Web Services account as the general purpose bucket. The specified metadata table name must be unique within the <code>aws_s3_metadata</code> namespace in the destination table bucket.</p>
    pub fn get_s3_tables_destination(&self) -> &::std::option::Option<crate::types::S3TablesDestination> {
        &self.s3_tables_destination
    }
    /// Consumes the builder and constructs a [`MetadataTableConfiguration`](crate::types::MetadataTableConfiguration).
    pub fn build(self) -> crate::types::MetadataTableConfiguration {
        crate::types::MetadataTableConfiguration {
            s3_tables_destination: self.s3_tables_destination,
        }
    }
}
