// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The specified updates to the S3 Metadata inventory table configuration.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct InventoryTableConfigurationUpdates {
    /// <p>The configuration state of the inventory table, indicating whether the inventory table is enabled or disabled.</p>
    pub configuration_state: crate::types::InventoryConfigurationState,
    /// <p>The encryption configuration for the inventory table.</p>
    pub encryption_configuration: ::std::option::Option<crate::types::MetadataTableEncryptionConfiguration>,
}
impl InventoryTableConfigurationUpdates {
    /// <p>The configuration state of the inventory table, indicating whether the inventory table is enabled or disabled.</p>
    pub fn configuration_state(&self) -> &crate::types::InventoryConfigurationState {
        &self.configuration_state
    }
    /// <p>The encryption configuration for the inventory table.</p>
    pub fn encryption_configuration(&self) -> ::std::option::Option<&crate::types::MetadataTableEncryptionConfiguration> {
        self.encryption_configuration.as_ref()
    }
}
impl InventoryTableConfigurationUpdates {
    /// Creates a new builder-style object to manufacture [`InventoryTableConfigurationUpdates`](crate::types::InventoryTableConfigurationUpdates).
    pub fn builder() -> crate::types::builders::InventoryTableConfigurationUpdatesBuilder {
        crate::types::builders::InventoryTableConfigurationUpdatesBuilder::default()
    }
}

/// A builder for [`InventoryTableConfigurationUpdates`](crate::types::InventoryTableConfigurationUpdates).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct InventoryTableConfigurationUpdatesBuilder {
    pub(crate) configuration_state: ::std::option::Option<crate::types::InventoryConfigurationState>,
    pub(crate) encryption_configuration: ::std::option::Option<crate::types::MetadataTableEncryptionConfiguration>,
}
impl InventoryTableConfigurationUpdatesBuilder {
    /// <p>The configuration state of the inventory table, indicating whether the inventory table is enabled or disabled.</p>
    /// This field is required.
    pub fn configuration_state(mut self, input: crate::types::InventoryConfigurationState) -> Self {
        self.configuration_state = ::std::option::Option::Some(input);
        self
    }
    /// <p>The configuration state of the inventory table, indicating whether the inventory table is enabled or disabled.</p>
    pub fn set_configuration_state(mut self, input: ::std::option::Option<crate::types::InventoryConfigurationState>) -> Self {
        self.configuration_state = input;
        self
    }
    /// <p>The configuration state of the inventory table, indicating whether the inventory table is enabled or disabled.</p>
    pub fn get_configuration_state(&self) -> &::std::option::Option<crate::types::InventoryConfigurationState> {
        &self.configuration_state
    }
    /// <p>The encryption configuration for the inventory table.</p>
    pub fn encryption_configuration(mut self, input: crate::types::MetadataTableEncryptionConfiguration) -> Self {
        self.encryption_configuration = ::std::option::Option::Some(input);
        self
    }
    /// <p>The encryption configuration for the inventory table.</p>
    pub fn set_encryption_configuration(mut self, input: ::std::option::Option<crate::types::MetadataTableEncryptionConfiguration>) -> Self {
        self.encryption_configuration = input;
        self
    }
    /// <p>The encryption configuration for the inventory table.</p>
    pub fn get_encryption_configuration(&self) -> &::std::option::Option<crate::types::MetadataTableEncryptionConfiguration> {
        &self.encryption_configuration
    }
    /// Consumes the builder and constructs a [`InventoryTableConfigurationUpdates`](crate::types::InventoryTableConfigurationUpdates).
    /// This method will fail if any of the following fields are not set:
    /// - [`configuration_state`](crate::types::builders::InventoryTableConfigurationUpdatesBuilder::configuration_state)
    pub fn build(self) -> ::std::result::Result<crate::types::InventoryTableConfigurationUpdates, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::InventoryTableConfigurationUpdates {
            configuration_state: self.configuration_state.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "configuration_state",
                    "configuration_state was not specified but it is required when building InventoryTableConfigurationUpdates",
                )
            })?,
            encryption_configuration: self.encryption_configuration,
        })
    }
}
