/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.mixed;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.fuseable.SimpleQueue;
import io.reactivex.rxjava3.internal.operators.mixed.ConcatMapXMainSubscriber;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class FlowableConcatMapCompletable<T>
extends Completable {
    final Flowable<T> source;
    final Function<? super T, ? extends CompletableSource> mapper;
    final ErrorMode errorMode;
    final int prefetch;

    public FlowableConcatMapCompletable(Flowable<T> source, Function<? super T, ? extends CompletableSource> mapper, ErrorMode errorMode, int prefetch) {
        this.source = source;
        this.mapper = mapper;
        this.errorMode = errorMode;
        this.prefetch = prefetch;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        this.source.subscribe((FlowableSubscriber<? super T>)new ConcatMapCompletableObserver<T>(observer, this.mapper, this.errorMode, this.prefetch));
    }

    static final class ConcatMapCompletableObserver<T>
    extends ConcatMapXMainSubscriber<T>
    implements Disposable {
        private static final long serialVersionUID = 3610901111000061034L;
        final CompletableObserver downstream;
        final Function<? super T, ? extends CompletableSource> mapper;
        final ConcatMapInnerObserver inner;
        volatile boolean active;
        int consumed;

        ConcatMapCompletableObserver(CompletableObserver downstream, Function<? super T, ? extends CompletableSource> mapper, ErrorMode errorMode, int prefetch) {
            super(prefetch, errorMode);
            this.downstream = downstream;
            this.mapper = mapper;
            this.inner = new ConcatMapInnerObserver(this);
        }

        @Override
        void onSubscribeDownstream() {
            this.downstream.onSubscribe(this);
        }

        @Override
        void disposeInner() {
            this.inner.dispose();
        }

        @Override
        public void dispose() {
            this.stop();
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void innerError(Throwable ex) {
            if (this.errors.tryAddThrowableOrReport(ex)) {
                if (this.errorMode == ErrorMode.IMMEDIATE) {
                    this.upstream.cancel();
                    this.errors.tryTerminateConsumer(this.downstream);
                    if (this.getAndIncrement() == 0) {
                        this.queue.clear();
                    }
                } else {
                    this.active = false;
                    this.drain();
                }
            }
        }

        void innerComplete() {
            this.active = false;
            this.drain();
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            ErrorMode errorMode = this.errorMode;
            SimpleQueue queue = this.queue;
            AtomicThrowable errors = this.errors;
            boolean syncFused = this.syncFused;
            do {
                CompletableSource cs;
                boolean empty;
                Object v;
                if (this.cancelled) {
                    queue.clear();
                    return;
                }
                if (errors.get() != null && (errorMode == ErrorMode.IMMEDIATE || errorMode == ErrorMode.BOUNDARY && !this.active)) {
                    queue.clear();
                    errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                if (this.active) continue;
                boolean d = this.done;
                try {
                    v = queue.poll();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.upstream.cancel();
                    errors.tryAddThrowableOrReport(ex);
                    errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                boolean bl = empty = v == null;
                if (d && empty) {
                    errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                if (empty) continue;
                int limit = this.prefetch - (this.prefetch >> 1);
                if (!syncFused) {
                    int c = this.consumed + 1;
                    if (c == limit) {
                        this.consumed = 0;
                        this.upstream.request((long)limit);
                    } else {
                        this.consumed = c;
                    }
                }
                try {
                    cs = Objects.requireNonNull(this.mapper.apply(v), "The mapper returned a null CompletableSource");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    queue.clear();
                    this.upstream.cancel();
                    errors.tryAddThrowableOrReport(ex);
                    errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                this.active = true;
                cs.subscribe(this.inner);
            } while (this.decrementAndGet() != 0);
        }

        static final class ConcatMapInnerObserver
        extends AtomicReference<Disposable>
        implements CompletableObserver {
            private static final long serialVersionUID = 5638352172918776687L;
            final ConcatMapCompletableObserver<?> parent;

            ConcatMapInnerObserver(ConcatMapCompletableObserver<?> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.replace(this, d);
            }

            @Override
            public void onError(Throwable e) {
                this.parent.innerError(e);
            }

            @Override
            public void onComplete() {
                this.parent.innerComplete();
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

