/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.IOException;
import java.util.Optional;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.NotPrimaryDeviceException;
import org.asamk.signal.output.OutputWriter;

public class RemovePinCommand
implements JsonRpcLocalCommand {
    @Override
    public String getName() {
        return "removePin";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Remove the registration lock pin.");
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        try {
            m.setRegistrationLockPin(Optional.empty());
        }
        catch (IOException e) {
            throw new IOErrorException("Remove pin error: " + e.getMessage(), e);
        }
        catch (NotPrimaryDeviceException e) {
            throw new UserErrorException("This command doesn't work on linked devices.");
        }
    }
}

