/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.OutputType;
import org.asamk.signal.ReceiveMessageHandler;
import org.asamk.signal.Shutdown;
import org.asamk.signal.commands.JsonRpcSingleCommand;
import org.asamk.signal.commands.LocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.json.JsonReceiveMessageHandler;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.AlreadyReceivingException;
import org.asamk.signal.manager.api.ReceiveConfig;
import org.asamk.signal.output.JsonWriter;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.output.PlainTextWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveCommand
implements LocalCommand,
JsonRpcSingleCommand<ReceiveParams> {
    private static final Logger logger = LoggerFactory.getLogger(ReceiveCommand.class);

    @Override
    public String getName() {
        return "receive";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Query the server for new messages.");
        subparser.addArgument(new String[]{"-t", "--timeout"}).type(Double.TYPE).setDefault((Object)3.0).help("Number of seconds to wait for new messages (negative values disable timeout)");
        subparser.addArgument(new String[]{"--max-messages"}).type(Integer.TYPE).setDefault((Object)-1).help("Maximum number of messages to receive, before returning.");
        subparser.addArgument(new String[]{"--ignore-attachments"}).help("Don\u2019t download attachments of received messages.").action((ArgumentAction)Arguments.storeTrue());
        subparser.addArgument(new String[]{"--ignore-stories"}).help("Don\u2019t receive story messages from the server.").action((ArgumentAction)Arguments.storeTrue());
        subparser.addArgument(new String[]{"--send-read-receipts"}).help("Send read receipts for all incoming data messages (in addition to the default delivery receipts)").action((ArgumentAction)Arguments.storeTrue());
    }

    @Override
    public List<OutputType> getSupportedOutputTypes() {
        return List.of(OutputType.PLAIN_TEXT, OutputType.JSON);
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        Shutdown.installHandler();
        Double timeout = ns.getDouble("timeout");
        Integer maxMessagesRaw = ns.getInt("max-messages");
        boolean ignoreAttachments = Boolean.TRUE.equals(ns.getBoolean("ignore-attachments"));
        boolean ignoreStories = Boolean.TRUE.equals(ns.getBoolean("ignore-stories"));
        boolean sendReadReceipts = Boolean.TRUE.equals(ns.getBoolean("send-read-receipts"));
        m.setReceiveConfig(new ReceiveConfig(ignoreAttachments, ignoreStories, sendReadReceipts));
        try {
            OutputWriter outputWriter2 = outputWriter;
            Objects.requireNonNull(outputWriter2);
            OutputWriter outputWriter3 = outputWriter2;
            int n = 0;
            Object handler = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonWriter.class, PlainTextWriter.class}, (Object)outputWriter3, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    JsonWriter writer = (JsonWriter)outputWriter3;
                    yield new JsonReceiveMessageHandler(m, writer);
                }
                case 1 -> {
                    PlainTextWriter writer = (PlainTextWriter)outputWriter3;
                    yield new ReceiveMessageHandler(m, writer);
                }
            };
            Duration duration = timeout < 0.0 ? null : Duration.ofMillis((long)(timeout * 1000.0));
            Integer maxMessages = maxMessagesRaw < 0 ? null : maxMessagesRaw;
            Shutdown.registerShutdownListener(() -> ((Manager)m).stopReceiveMessages());
            m.receiveMessages(Optional.ofNullable(duration), Optional.ofNullable(maxMessages), (Manager.ReceiveMessageHandler)handler);
        }
        catch (IOException e) {
            throw new IOErrorException("Error while receiving messages: " + e.getMessage(), e);
        }
        catch (AlreadyReceivingException e) {
            throw new UserErrorException("Receive command cannot be used if messages are already being received.", e);
        }
    }

    @Override
    public TypeReference<ReceiveParams> getRequestType() {
        return new TypeReference<ReceiveParams>(this){};
    }

    @Override
    public void handleCommand(ReceiveParams request, Manager m, JsonWriter jsonWriter) throws CommandException {
        double timeout = request.timeout() == null ? 3.0 : request.timeout();
        int maxMessagesRaw = request.maxMessages() == null ? -1 : request.maxMessages();
        try {
            ArrayList messages = new ArrayList();
            JsonReceiveMessageHandler handler = new JsonReceiveMessageHandler(m, messages::add);
            Duration duration = timeout < 0.0 ? null : Duration.ofMillis((long)(timeout * 1000.0));
            Integer maxMessages = maxMessagesRaw < 0 ? null : Integer.valueOf(maxMessagesRaw);
            m.receiveMessages(Optional.ofNullable(duration), Optional.ofNullable(maxMessages), (Manager.ReceiveMessageHandler)handler);
            jsonWriter.write(messages);
        }
        catch (IOException e) {
            throw new IOErrorException("Error while receiving messages: " + e.getMessage(), e);
        }
        catch (AlreadyReceivingException e) {
            throw new UserErrorException("Receive command cannot be used if messages are already being received.", e);
        }
    }

    public record ReceiveParams(Double timeout, Integer maxMessages) {
    }
}

