/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.util;

import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import org.asamk.signal.manager.api.AttachmentInvalidException;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.util.Utils;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentStream;
import org.whispersystems.signalservice.api.push.exceptions.ResumeLocationInvalidException;
import org.whispersystems.signalservice.api.util.StreamDetails;
import org.whispersystems.signalservice.internal.push.http.ResumableUploadSpec;

public class AttachmentUtils {
    public static SignalServiceAttachmentStream createAttachmentStream(String attachment, ResumableUploadSpec resumableUploadSpec) throws AttachmentInvalidException {
        try {
            Pair<StreamDetails, Optional<String>> streamDetails = Utils.createStreamDetails(attachment);
            return AttachmentUtils.createAttachmentStream(streamDetails.first(), streamDetails.second(), resumableUploadSpec);
        }
        catch (IOException e) {
            throw new AttachmentInvalidException(attachment, e);
        }
    }

    public static SignalServiceAttachmentStream createAttachmentStream(StreamDetails streamDetails, Optional<String> name, ResumableUploadSpec resumableUploadSpec) throws ResumeLocationInvalidException {
        long uploadTimestamp = System.currentTimeMillis();
        return SignalServiceAttachmentStream.newStreamBuilder().withStream(streamDetails.getStream()).withContentType(streamDetails.getContentType()).withLength(streamDetails.getLength()).withFileName((String)name.orElse(null)).withUploadTimestamp(uploadTimestamp).withResumableUploadSpec(resumableUploadSpec).withUuid(UUID.randomUUID()).build();
    }
}

