/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.syncStorage;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import java.util.UUID;
import okio.ByteString;
import org.asamk.signal.manager.api.PhoneNumberSharingMode;
import org.asamk.signal.manager.api.TrustLevel;
import org.asamk.signal.manager.storage.configuration.ConfigurationStore;
import org.asamk.signal.manager.storage.groups.GroupInfoV1;
import org.asamk.signal.manager.storage.groups.GroupInfoV2;
import org.asamk.signal.manager.storage.identities.IdentityInfo;
import org.asamk.signal.manager.storage.recipients.Recipient;
import org.asamk.signal.manager.storage.recipients.RecipientAddress;
import org.signal.core.util.StringExtensionsKt;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.UsernameLinkComponents;
import org.whispersystems.signalservice.api.storage.SignalAccountRecord;
import org.whispersystems.signalservice.api.storage.SignalContactRecord;
import org.whispersystems.signalservice.api.storage.SignalGroupV1Record;
import org.whispersystems.signalservice.api.storage.SignalGroupV2Record;
import org.whispersystems.signalservice.api.util.UuidUtil;
import org.whispersystems.signalservice.internal.storage.protos.AccountRecord;
import org.whispersystems.signalservice.internal.storage.protos.ContactRecord;
import org.whispersystems.signalservice.internal.storage.protos.GroupV1Record;
import org.whispersystems.signalservice.internal.storage.protos.GroupV2Record;

public final class StorageSyncModels {
    private StorageSyncModels() {
    }

    public static AccountRecord.PhoneNumberSharingMode localToRemote(PhoneNumberSharingMode phoneNumberPhoneNumberSharingMode) {
        return switch (phoneNumberPhoneNumberSharingMode) {
            default -> throw new MatchException(null, null);
            case PhoneNumberSharingMode.EVERYBODY -> AccountRecord.PhoneNumberSharingMode.EVERYBODY;
            case PhoneNumberSharingMode.CONTACTS, PhoneNumberSharingMode.NOBODY -> AccountRecord.PhoneNumberSharingMode.NOBODY;
        };
    }

    public static PhoneNumberSharingMode remoteToLocal(AccountRecord.PhoneNumberSharingMode phoneNumberPhoneNumberSharingMode) {
        return switch (phoneNumberPhoneNumberSharingMode) {
            default -> throw new MatchException(null, null);
            case AccountRecord.PhoneNumberSharingMode.EVERYBODY -> PhoneNumberSharingMode.EVERYBODY;
            case AccountRecord.PhoneNumberSharingMode.NOBODY -> PhoneNumberSharingMode.NOBODY;
            case AccountRecord.PhoneNumberSharingMode.UNKNOWN -> null;
        };
    }

    public static AccountRecord localToRemoteRecord(Connection connection, ConfigurationStore configStore, Recipient self, UsernameLinkComponents usernameLinkComponents) throws SQLException {
        AccountRecord.Builder builder = SignalAccountRecord.Companion.newBuilder(self.getStorageRecord());
        if (self.getProfileKey() != null) {
            builder.profileKey(ByteString.of((byte[])self.getProfileKey().serialize()));
        }
        if (self.getProfile() != null) {
            builder.givenName(StringExtensionsKt.emptyIfNull((String)self.getProfile().getGivenName())).familyName(StringExtensionsKt.emptyIfNull((String)self.getProfile().getFamilyName())).avatarUrlPath(StringExtensionsKt.emptyIfNull((String)self.getProfile().getAvatarUrlPath()));
        }
        builder.typingIndicators(Optional.ofNullable(configStore.getTypingIndicators(connection)).orElse(true).booleanValue()).readReceipts(Optional.ofNullable(configStore.getReadReceipts(connection)).orElse(true).booleanValue()).sealedSenderIndicators(Optional.ofNullable(configStore.getUnidentifiedDeliveryIndicators(connection)).orElse(true).booleanValue()).linkPreviews(Optional.ofNullable(configStore.getLinkPreviews(connection)).orElse(true).booleanValue()).unlistedPhoneNumber(Optional.ofNullable(configStore.getPhoneNumberUnlisted(connection)).orElse(false).booleanValue()).phoneNumberSharingMode(Optional.ofNullable(configStore.getPhoneNumberSharingMode(connection)).map(StorageSyncModels::localToRemote).orElse(AccountRecord.PhoneNumberSharingMode.UNKNOWN)).username(self.getAddress().username().orElse(""));
        if (usernameLinkComponents != null) {
            String linkColor = configStore.getUsernameLinkColor(connection);
            builder.usernameLink(new AccountRecord.UsernameLink.Builder().entropy(ByteString.of((byte[])usernameLinkComponents.getEntropy())).serverId(UuidUtil.toByteString((UUID)usernameLinkComponents.getServerId())).color(linkColor == null ? AccountRecord.UsernameLink.Color.UNKNOWN : AccountRecord.UsernameLink.Color.valueOf((String)linkColor)).build());
        }
        return builder.build();
    }

    public static ContactRecord localToRemoteRecord(Recipient recipient, IdentityInfo identity) {
        RecipientAddress address = recipient.getAddress();
        ContactRecord.Builder builder = SignalContactRecord.Companion.newBuilder(recipient.getStorageRecord()).aci(address.aci().map(ServiceId.ACI::toString).orElse("")).e164(address.number().orElse("")).pni(address.pni().map(ServiceId.PNI::toStringWithoutPrefix).orElse("")).username(address.username().orElse("")).profileKey(recipient.getProfileKey() == null ? ByteString.EMPTY : ByteString.of((byte[])recipient.getProfileKey().serialize()));
        if (recipient.getProfile() != null) {
            builder.givenName(StringExtensionsKt.emptyIfNull((String)recipient.getProfile().getGivenName())).familyName(StringExtensionsKt.emptyIfNull((String)recipient.getProfile().getFamilyName()));
        }
        if (recipient.getContact() != null) {
            builder.systemGivenName(StringExtensionsKt.emptyIfNull((String)recipient.getContact().givenName())).systemFamilyName(StringExtensionsKt.emptyIfNull((String)recipient.getContact().familyName())).systemNickname(StringExtensionsKt.emptyIfNull((String)recipient.getContact().nickName())).nickname(new ContactRecord.Name.Builder().given(StringExtensionsKt.emptyIfNull((String)recipient.getContact().nickNameGivenName())).family(StringExtensionsKt.emptyIfNull((String)recipient.getContact().nickNameFamilyName())).build()).note(StringExtensionsKt.emptyIfNull((String)recipient.getContact().note())).blocked(recipient.getContact().isBlocked()).whitelisted(recipient.getContact().isProfileSharingEnabled()).mutedUntilTimestamp(recipient.getContact().muteUntil()).hideStory(recipient.getContact().hideStory()).unregisteredAtTimestamp(recipient.getContact().unregisteredTimestamp() == null ? 0L : recipient.getContact().unregisteredTimestamp()).archived(recipient.getContact().isArchived()).hidden(recipient.getContact().isHidden());
        }
        if (identity != null) {
            builder.identityKey(ByteString.of((byte[])identity.getIdentityKey().serialize())).identityState(StorageSyncModels.localToRemote(identity.getTrustLevel()));
        }
        return builder.build();
    }

    public static GroupV1Record localToRemoteRecord(GroupInfoV1 group) {
        GroupV1Record.Builder builder = SignalGroupV1Record.Companion.newBuilder(group.getStorageRecord());
        builder.id(ByteString.of((byte[])group.getGroupId().serialize()));
        builder.blocked(group.isBlocked());
        builder.archived(group.archived);
        builder.whitelisted(true);
        return builder.build();
    }

    public static GroupV2Record localToRemoteRecord(GroupInfoV2 group) {
        GroupV2Record.Builder builder = SignalGroupV2Record.Companion.newBuilder(group.getStorageRecord());
        builder.masterKey(ByteString.of((byte[])group.getMasterKey().serialize()));
        builder.blocked(group.isBlocked());
        builder.whitelisted(group.isProfileSharingEnabled());
        return builder.build();
    }

    public static TrustLevel remoteToLocal(ContactRecord.IdentityState identityState) {
        return switch (identityState) {
            default -> throw new MatchException(null, null);
            case ContactRecord.IdentityState.DEFAULT -> TrustLevel.TRUSTED_UNVERIFIED;
            case ContactRecord.IdentityState.UNVERIFIED -> TrustLevel.UNTRUSTED;
            case ContactRecord.IdentityState.VERIFIED -> TrustLevel.TRUSTED_VERIFIED;
        };
    }

    private static ContactRecord.IdentityState localToRemote(TrustLevel local) {
        return switch (local) {
            case TrustLevel.TRUSTED_VERIFIED -> ContactRecord.IdentityState.VERIFIED;
            case TrustLevel.UNTRUSTED -> ContactRecord.IdentityState.UNVERIFIED;
            default -> ContactRecord.IdentityState.DEFAULT;
        };
    }
}

