/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.protocol;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import org.asamk.signal.manager.storage.Utils;
import org.asamk.signal.manager.storage.protocol.LegacySessionInfo;
import org.asamk.signal.manager.storage.recipients.RecipientAddress;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.util.UuidUtil;

public class LegacyJsonSessionStore {
    private final List<LegacySessionInfo> sessions;

    private LegacyJsonSessionStore(List<LegacySessionInfo> sessions) {
        this.sessions = sessions;
    }

    public List<LegacySessionInfo> getSessions() {
        return this.sessions;
    }

    public static class JsonSessionStoreDeserializer
    extends JsonDeserializer<LegacyJsonSessionStore> {
        public LegacyJsonSessionStore deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            ArrayList<LegacySessionInfo> sessions = new ArrayList<LegacySessionInfo>();
            if (node.isArray()) {
                for (JsonNode session : node) {
                    String sessionName = session.hasNonNull("name") ? session.get("name").asText() : null;
                    if (UuidUtil.isUuid((String)sessionName)) continue;
                    UUID uuid = session.hasNonNull("uuid") ? UuidUtil.parseOrNull((String)session.get("uuid").asText()) : null;
                    RecipientAddress address = uuid == null ? Utils.getRecipientAddressFromLegacyIdentifier(sessionName) : new RecipientAddress(ServiceId.ACI.from((UUID)uuid), sessionName);
                    int deviceId = session.get("deviceId").asInt();
                    byte[] record = Base64.getDecoder().decode(session.get("record").asText());
                    LegacySessionInfo sessionInfo = new LegacySessionInfo(address, deviceId, record);
                    sessions.add(sessionInfo);
                }
            }
            return new LegacyJsonSessionStore(sessions);
        }
    }
}

