/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.function.Function;
import org.slf4j.Logger;
import org.sqlite.SQLiteConfig;

public abstract class Database
implements AutoCloseable {
    private final Logger logger;
    private final long databaseVersion;
    private final HikariDataSource dataSource;

    protected Database(Logger logger, long databaseVersion, HikariDataSource dataSource) {
        this.logger = logger;
        this.databaseVersion = databaseVersion;
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Database> T initDatabase(File databaseFile, Function<HikariDataSource, T> newDatabase) throws SQLException {
        try (HikariDataSource dataSource = null;){
            dataSource = Database.getHikariDataSource(databaseFile.getAbsolutePath());
            Database result = (Database)newDatabase.apply(dataSource);
            result.initDb();
            dataSource = null;
            Database database = result;
            return (T)database;
        }
    }

    public final Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public void close() {
        this.dataSource.close();
    }

    protected final void initDb() throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            connection.setAutoCommit(false);
            long userVersion = Database.getUserVersion(connection);
            this.logger.trace("Current database version: {} Program database version: {}", (Object)userVersion, (Object)this.databaseVersion);
            if (userVersion == 0L) {
                this.createDatabase(connection);
                Database.setUserVersion(connection, this.databaseVersion);
            } else {
                if (userVersion > this.databaseVersion) {
                    this.logger.error("Database has been updated by a newer signal-cli version");
                    throw new SQLException("Database has been updated by a newer signal-cli version");
                }
                if (userVersion < this.databaseVersion) {
                    this.upgradeDatabase(connection, userVersion);
                    Database.setUserVersion(connection, this.databaseVersion);
                }
            }
            connection.commit();
        }
    }

    protected abstract void createDatabase(Connection var1) throws SQLException;

    protected abstract void upgradeDatabase(Connection var1, long var2) throws SQLException;

    private static long getUserVersion(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            ResultSet resultSet = statement.executeQuery("PRAGMA user_version");
            long l = resultSet.getLong(1);
            return l;
        }
    }

    private static void setUserVersion(Connection connection, long userVersion) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("PRAGMA user_version = " + userVersion);
        }
    }

    private static HikariDataSource getHikariDataSource(String databaseFile) {
        SQLiteConfig sqliteConfig = new SQLiteConfig();
        sqliteConfig.setBusyTimeout(60000);
        sqliteConfig.setTransactionMode(SQLiteConfig.TransactionMode.IMMEDIATE);
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl("jdbc:sqlite:" + databaseFile + "?foreign_keys=ON&journal_mode=wal");
        config.setDataSourceProperties(sqliteConfig.toProperties());
        config.setMinimumIdle(1);
        config.setConnectionTimeout(90000L);
        config.setMaximumPoolSize(50);
        config.setMaxLifetime(0L);
        return new HikariDataSource(config);
    }
}

