/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.jobs;

import org.asamk.signal.manager.helper.Context;
import org.asamk.signal.manager.jobs.Job;
import org.asamk.signal.manager.storage.SignalAccount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadProfileAvatarJob
implements Job {
    private static final Logger logger = LoggerFactory.getLogger(DownloadProfileAvatarJob.class);
    private final String avatarPath;

    public DownloadProfileAvatarJob(String avatarPath) {
        this.avatarPath = avatarPath;
    }

    @Override
    public void run(Context context) {
        logger.trace("Downloading profile avatar {}", (Object)this.avatarPath);
        SignalAccount account = context.getAccount();
        context.getProfileHelper().downloadProfileAvatar(account.getSelfRecipientId(), this.avatarPath, account.getProfileKey());
    }
}

