/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.internal;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.asamk.signal.manager.helper.Context;
import org.asamk.signal.manager.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobExecutor
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(JobExecutor.class);
    private final Context context;
    private final ExecutorService executorService;
    private Job running;
    private final Queue<Job> queue = new ArrayDeque<Job>();

    public JobExecutor(Context context) {
        this.context = context;
        this.executorService = Executors.newCachedThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueJob(Job job) {
        if (this.executorService.isShutdown()) {
            logger.debug("Not enqueuing {} job, shutting down", (Object)job.getClass().getSimpleName());
            return;
        }
        Queue<Job> queue = this.queue;
        synchronized (queue) {
            logger.trace("Enqueuing {} job", (Object)job.getClass().getSimpleName());
            this.queue.add(job);
        }
        this.runNextJob();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runNextJob() {
        Job job;
        Object object = this.queue;
        synchronized (object) {
            if (this.running != null) {
                return;
            }
            this.running = job = this.queue.poll();
        }
        if (job == null) {
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
            return;
        }
        logger.debug("Running {} job", (Object)job.getClass().getSimpleName());
        this.executorService.execute(() -> {
            try {
                job.run(this.context);
            }
            catch (Throwable e) {
                logger.warn("Job {} failed", (Object)job.getClass().getSimpleName(), (Object)e);
            }
            finally {
                Queue<Job> queue = this.queue;
                synchronized (queue) {
                    this.running = null;
                }
                this.runNextJob();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        boolean queueEmpty;
        Object object = this.queue;
        synchronized (object) {
            queueEmpty = this.queue.isEmpty();
        }
        if (queueEmpty) {
            this.executorService.close();
            return;
        }
        object = this;
        synchronized (object) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.executorService.close();
    }
}

