/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.api;

public class UpdateProfile {
    private final String givenName;
    private final String familyName;
    private final String about;
    private final String aboutEmoji;
    private final String avatar;
    private final boolean deleteAvatar;
    private final byte[] mobileCoinAddress;

    private UpdateProfile(Builder builder) {
        this.givenName = builder.givenName;
        this.familyName = builder.familyName;
        this.about = builder.about;
        this.aboutEmoji = builder.aboutEmoji;
        this.avatar = builder.avatar;
        this.deleteAvatar = builder.deleteAvatar;
        this.mobileCoinAddress = builder.mobileCoinAddress;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(UpdateProfile copy) {
        Builder builder = new Builder();
        builder.givenName = copy.getGivenName();
        builder.familyName = copy.getFamilyName();
        builder.about = copy.getAbout();
        builder.aboutEmoji = copy.getAboutEmoji();
        builder.avatar = copy.getAvatar();
        builder.deleteAvatar = copy.isDeleteAvatar();
        builder.mobileCoinAddress = copy.getMobileCoinAddress();
        return builder;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getAbout() {
        return this.about;
    }

    public String getAboutEmoji() {
        return this.aboutEmoji;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public boolean isDeleteAvatar() {
        return this.deleteAvatar;
    }

    public byte[] getMobileCoinAddress() {
        return this.mobileCoinAddress;
    }

    public static final class Builder {
        private String givenName;
        private String familyName;
        private String about;
        private String aboutEmoji;
        private String avatar;
        private boolean deleteAvatar;
        private byte[] mobileCoinAddress;

        private Builder() {
        }

        public Builder withGivenName(String val) {
            this.givenName = val;
            return this;
        }

        public Builder withFamilyName(String val) {
            this.familyName = val;
            return this;
        }

        public Builder withAbout(String val) {
            this.about = val;
            return this;
        }

        public Builder withAboutEmoji(String val) {
            this.aboutEmoji = val;
            return this;
        }

        public Builder withAvatar(String val) {
            this.avatar = val;
            return this;
        }

        public Builder withDeleteAvatar(boolean val) {
            this.deleteAvatar = val;
            return this;
        }

        public Builder withMobileCoinAddress(byte[] val) {
            this.mobileCoinAddress = val;
            return this;
        }

        public UpdateProfile build() {
            return new UpdateProfile(this);
        }
    }
}

