/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.api;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.asamk.signal.manager.api.PhoneNumberSharingMode;
import org.whispersystems.signalservice.internal.util.Util;

public class Profile {
    private final long lastUpdateTimestamp;
    private final String givenName;
    private final String familyName;
    private final String about;
    private final String aboutEmoji;
    private final String avatarUrlPath;
    private final byte[] mobileCoinAddress;
    private final UnidentifiedAccessMode unidentifiedAccessMode;
    private final Set<Capability> capabilities;
    private final PhoneNumberSharingMode phoneNumberSharingMode;

    public Profile(long lastUpdateTimestamp, String givenName, String familyName, String about, String aboutEmoji, String avatarUrlPath, byte[] mobileCoinAddress, UnidentifiedAccessMode unidentifiedAccessMode, Set<Capability> capabilities, PhoneNumberSharingMode phoneNumberSharingMode) {
        this.lastUpdateTimestamp = lastUpdateTimestamp;
        this.givenName = givenName;
        this.familyName = familyName;
        this.about = about;
        this.aboutEmoji = aboutEmoji;
        this.avatarUrlPath = avatarUrlPath;
        this.mobileCoinAddress = mobileCoinAddress;
        this.unidentifiedAccessMode = unidentifiedAccessMode;
        this.capabilities = capabilities;
        this.phoneNumberSharingMode = phoneNumberSharingMode;
    }

    private Profile(Builder builder) {
        this.lastUpdateTimestamp = builder.lastUpdateTimestamp;
        this.givenName = builder.givenName;
        this.familyName = builder.familyName;
        this.about = builder.about;
        this.aboutEmoji = builder.aboutEmoji;
        this.avatarUrlPath = builder.avatarUrlPath;
        this.mobileCoinAddress = builder.mobileCoinAddress;
        this.unidentifiedAccessMode = builder.unidentifiedAccessMode;
        this.capabilities = builder.capabilities;
        this.phoneNumberSharingMode = builder.phoneNumberSharingMode;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Profile copy) {
        Builder builder = new Builder();
        builder.lastUpdateTimestamp = copy.getLastUpdateTimestamp();
        builder.givenName = copy.getGivenName();
        builder.familyName = copy.getFamilyName();
        builder.about = copy.getAbout();
        builder.aboutEmoji = copy.getAboutEmoji();
        builder.avatarUrlPath = copy.getAvatarUrlPath();
        builder.mobileCoinAddress = copy.getMobileCoinAddress();
        builder.unidentifiedAccessMode = copy.getUnidentifiedAccessMode();
        builder.capabilities = copy.getCapabilities();
        return builder;
    }

    public long getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getInternalServiceName() {
        if (this.familyName == null) {
            return this.givenName == null ? "" : this.givenName;
        }
        return String.join((CharSequence)"\u0000", this.givenName == null ? "" : this.givenName, this.familyName);
    }

    public String getDisplayName() {
        boolean noGivenName = Util.isEmpty((String)this.givenName);
        boolean noFamilyName = Util.isEmpty((String)this.familyName);
        if (noGivenName && noFamilyName) {
            return "";
        }
        if (noGivenName) {
            return this.familyName;
        }
        if (noFamilyName) {
            return this.givenName;
        }
        return this.givenName + " " + this.familyName;
    }

    public String getAbout() {
        return this.about;
    }

    public String getAboutEmoji() {
        return this.aboutEmoji;
    }

    public String getAvatarUrlPath() {
        return this.avatarUrlPath;
    }

    public byte[] getMobileCoinAddress() {
        return this.mobileCoinAddress;
    }

    public UnidentifiedAccessMode getUnidentifiedAccessMode() {
        return this.unidentifiedAccessMode;
    }

    public Set<Capability> getCapabilities() {
        return this.capabilities;
    }

    public PhoneNumberSharingMode getPhoneNumberSharingMode() {
        return this.phoneNumberSharingMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Profile profile = (Profile)o;
        return this.lastUpdateTimestamp == profile.lastUpdateTimestamp && Objects.equals(this.givenName, profile.givenName) && Objects.equals(this.familyName, profile.familyName) && Objects.equals(this.about, profile.about) && Objects.equals(this.aboutEmoji, profile.aboutEmoji) && Objects.equals(this.avatarUrlPath, profile.avatarUrlPath) && this.unidentifiedAccessMode == profile.unidentifiedAccessMode && Objects.equals(this.capabilities, profile.capabilities);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lastUpdateTimestamp, this.givenName, this.familyName, this.about, this.aboutEmoji, this.avatarUrlPath, this.unidentifiedAccessMode, this.capabilities});
    }

    public static enum UnidentifiedAccessMode {
        UNKNOWN,
        DISABLED,
        ENABLED,
        UNRESTRICTED;


        public static UnidentifiedAccessMode valueOfOrUnknown(String value) {
            try {
                return UnidentifiedAccessMode.valueOf(value);
            }
            catch (IllegalArgumentException ignored) {
                return UNKNOWN;
            }
        }
    }

    public static final class Builder {
        private String givenName;
        private String familyName;
        private String about;
        private String aboutEmoji;
        private String avatarUrlPath;
        private byte[] mobileCoinAddress;
        private UnidentifiedAccessMode unidentifiedAccessMode = UnidentifiedAccessMode.UNKNOWN;
        private Set<Capability> capabilities = Collections.emptySet();
        private PhoneNumberSharingMode phoneNumberSharingMode;
        private long lastUpdateTimestamp = 0L;

        private Builder() {
        }

        public Builder withGivenName(String val) {
            this.givenName = val;
            return this;
        }

        public Builder withFamilyName(String val) {
            this.familyName = val;
            return this;
        }

        public Builder withAbout(String val) {
            this.about = val;
            return this;
        }

        public Builder withAboutEmoji(String val) {
            this.aboutEmoji = val;
            return this;
        }

        public Builder withAvatarUrlPath(String val) {
            this.avatarUrlPath = val;
            return this;
        }

        public Builder withUnidentifiedAccessMode(UnidentifiedAccessMode val) {
            this.unidentifiedAccessMode = val;
            return this;
        }

        public Builder withCapabilities(Set<Capability> val) {
            this.capabilities = val;
            return this;
        }

        public Builder withPhoneNumberSharingMode(PhoneNumberSharingMode val) {
            this.phoneNumberSharingMode = val;
            return this;
        }

        public Profile build() {
            return new Profile(this);
        }

        public Builder withLastUpdateTimestamp(long val) {
            this.lastUpdateTimestamp = val;
            return this;
        }

        public Builder withMobileCoinAddress(byte[] val) {
            this.mobileCoinAddress = val;
            return this;
        }
    }

    public static enum Capability {
        storage,
        storageServiceEncryptionV2Capability;


        public static Capability valueOfOrNull(String value) {
            try {
                return Capability.valueOf(value);
            }
            catch (IllegalArgumentException ignored) {
                return null;
            }
        }
    }
}

