/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class DBusMap<K, V>
implements Map<K, V> {
    Object[][] entries;

    public DBusMap(Object[][] _entries) {
        this.entries = _entries;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object _key) {
        for (Object[] entry : this.entries) {
            if (!Objects.equals(_key, entry[0])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object _value) {
        for (Object[] entry : this.entries) {
            if (!Objects.equals(_value, entry[1])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet<Map.Entry<K, V>> s = new LinkedHashSet<Map.Entry<K, V>>();
        for (int i = 0; i < this.entries.length; ++i) {
            s.add(new Entry(i));
        }
        return s;
    }

    @Override
    public V get(Object _key) {
        for (Object[] entry : this.entries) {
            if (_key != entry[0] && (_key == null || !_key.equals(entry[0]))) continue;
            return (V)entry[1];
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.entries.length == 0;
    }

    @Override
    public Set<K> keySet() {
        LinkedHashSet<Object> s = new LinkedHashSet<Object>();
        for (Object[] entry : this.entries) {
            s.add(entry[0]);
        }
        return s;
    }

    @Override
    public V put(K _key, V _value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> _t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object _key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    public Collection<V> values() {
        ArrayList<Object> l = new ArrayList<Object>();
        for (Object[] entry : this.entries) {
            l.add(entry[1]);
        }
        return l;
    }

    @Override
    public int hashCode() {
        return Arrays.deepHashCode((Object[])this.entries);
    }

    @Override
    public boolean equals(Object _o) {
        if (null == _o) {
            return false;
        }
        if (!(_o instanceof Map)) {
            return false;
        }
        return ((Map)_o).entrySet().equals(this.entrySet());
    }

    public String toString() {
        return "{" + Arrays.stream(this.entries).map(e -> String.valueOf(e[0]) + " => " + String.valueOf(e[1])).collect(Collectors.joining(",")) + "}";
    }

    class Entry
    implements Map.Entry<K, V>,
    Comparable<Entry> {
        private final int entryPosition;

        Entry(int _i) {
            this.entryPosition = _i;
        }

        @Override
        public boolean equals(Object _o) {
            if (null == _o) {
                return false;
            }
            if (!(_o instanceof Entry)) {
                return false;
            }
            return this.entryPosition == ((Entry)_o).entryPosition;
        }

        @Override
        public K getKey() {
            return DBusMap.this.entries[this.entryPosition][0];
        }

        @Override
        public V getValue() {
            return DBusMap.this.entries[this.entryPosition][1];
        }

        @Override
        public int hashCode() {
            return DBusMap.this.entries[this.entryPosition][0].hashCode();
        }

        @Override
        public V setValue(V _value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int compareTo(Entry _e) {
            return this.entryPosition - _e.entryPosition;
        }
    }
}

