/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.push.http;

import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.libsignal.protocol.incrementalmac.ChunkSizeChoice;
import org.signal.libsignal.protocol.incrementalmac.IncrementalMacOutputStream;
import org.whispersystems.signalservice.api.crypto.AttachmentCipherOutputStream;
import org.whispersystems.signalservice.api.crypto.DigestingOutputStream;
import org.whispersystems.signalservice.internal.push.http.OutputStreamFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J*\u0010\u000b\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/whispersystems/signalservice/internal/push/http/AttachmentCipherOutputStreamFactory;", "Lorg/whispersystems/signalservice/internal/push/http/OutputStreamFactory;", "key", "", "iv", "<init>", "([B[B)V", "createFor", "Lorg/whispersystems/signalservice/api/crypto/DigestingOutputStream;", "wrap", "Ljava/io/OutputStream;", "createIncrementalFor", "length", "", "sizeChoice", "Lorg/signal/libsignal/protocol/incrementalmac/ChunkSizeChoice;", "incrementalDigestOut", "Companion", "signal-service-java"})
public final class AttachmentCipherOutputStreamFactory
implements OutputStreamFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] key;
    @NotNull
    private final byte[] iv;
    private static final int AES_KEY_LENGTH = 32;

    public AttachmentCipherOutputStreamFactory(@NotNull byte[] key, @NotNull byte[] iv) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        this.key = key;
        this.iv = iv;
    }

    @Override
    @NotNull
    public DigestingOutputStream createFor(@NotNull OutputStream wrap) throws IOException {
        Intrinsics.checkNotNullParameter((Object)wrap, (String)"wrap");
        return new AttachmentCipherOutputStream(this.key, this.iv, wrap);
    }

    @NotNull
    public final DigestingOutputStream createIncrementalFor(@Nullable OutputStream wrap, long length, @NotNull ChunkSizeChoice sizeChoice, @Nullable OutputStream incrementalDigestOut) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sizeChoice, (String)"sizeChoice");
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Attachment length overflows int!");
        }
        byte[] privateKey = ArraysKt.sliceArray((byte[])this.key, (IntRange)RangesKt.until((int)32, (int)this.key.length));
        IncrementalMacOutputStream incrementalStream = new IncrementalMacOutputStream(wrap, privateKey, sizeChoice, incrementalDigestOut);
        return this.createFor((OutputStream)incrementalStream);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/whispersystems/signalservice/internal/push/http/AttachmentCipherOutputStreamFactory$Companion;", "", "<init>", "()V", "AES_KEY_LENGTH", "", "signal-service-java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

