/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.push;

import org.signal.libsignal.protocol.logging.Log;

public class PushTransportDetails {
    private static final String TAG = PushTransportDetails.class.getSimpleName();

    public byte[] getStrippedPaddingMessageBody(byte[] messageWithPadding) {
        int paddingStart = 0;
        for (int i = messageWithPadding.length - 1; i >= 0; --i) {
            if (messageWithPadding[i] == -128) {
                paddingStart = i;
                break;
            }
            if (messageWithPadding[i] == 0) continue;
            Log.w((String)TAG, (String)"Padding byte is malformed, returning unstripped padding.");
            return messageWithPadding;
        }
        byte[] strippedMessage = new byte[paddingStart];
        System.arraycopy(messageWithPadding, 0, strippedMessage, 0, strippedMessage.length);
        return strippedMessage;
    }

    public byte[] getPaddedMessageBody(byte[] messageBody) {
        byte[] paddedMessage = new byte[this.getPaddedMessageLength(messageBody.length + 1) - 1];
        System.arraycopy(messageBody, 0, paddedMessage, 0, messageBody.length);
        paddedMessage[messageBody.length] = -128;
        return paddedMessage;
    }

    private int getPaddedMessageLength(int messageLength) {
        int messageLengthWithTerminator = messageLength + 1;
        int messagePartCount = messageLengthWithTerminator / 160;
        if (messageLengthWithTerminator % 160 != 0) {
            ++messagePartCount;
        }
        return messagePartCount * 160;
    }
}

