/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.push;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.annotation.Nonnull;
import org.signal.core.util.Base64;
import org.signal.libsignal.protocol.IdentityKey;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.internal.util.JsonUtil;

public class IdentityCheckRequest {
    @JsonProperty(value="elements")
    private final List<ServiceIdFingerprintPair> serviceIdFingerprintPairs;

    public IdentityCheckRequest(@Nonnull List<ServiceIdFingerprintPair> serviceIdKeyPairs) {
        this.serviceIdFingerprintPairs = serviceIdKeyPairs;
    }

    public List<ServiceIdFingerprintPair> getServiceIdFingerprintPairs() {
        return this.serviceIdFingerprintPairs;
    }

    public static final class ServiceIdFingerprintPair {
        @JsonProperty(value="uuid")
        @JsonSerialize(using=JsonUtil.ServiceIdSerializer.class)
        private final ServiceId serviceId;
        @JsonProperty
        private final String fingerprint;

        public ServiceIdFingerprintPair(@Nonnull ServiceId serviceId, @Nonnull IdentityKey identityKey) {
            this.serviceId = serviceId;
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                this.fingerprint = Base64.encodeWithPadding((byte[])messageDigest.digest(identityKey.serialize()), (int)0, (int)4);
            }
            catch (NoSuchAlgorithmException e) {
                throw new AssertionError((Object)e);
            }
        }

        public ServiceId getServiceId() {
            return this.serviceId;
        }

        public String getFingerprint() {
            return this.fingerprint;
        }
    }
}

