/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.payments;

import org.whispersystems.signalservice.api.payments.Formatter;
import org.whispersystems.signalservice.api.payments.FormatterOptions;

public abstract class Currency {
    private Currency() {
    }

    public abstract String getCurrencyCode();

    public abstract int getDecimalPrecision();

    public abstract Formatter getFormatter(FormatterOptions var1);

    public static Currency fromJavaCurrency(java.util.Currency javaCurrency) {
        return new FiatCurrency(javaCurrency);
    }

    public static Currency fromCodeAndPrecision(String code, int decimalPrecision) {
        return new CryptoCurrency(code, decimalPrecision);
    }

    private static class FiatCurrency
    extends Currency {
        private final java.util.Currency javaCurrency;

        private FiatCurrency(java.util.Currency javaCurrency) {
            this.javaCurrency = javaCurrency;
        }

        @Override
        public String getCurrencyCode() {
            return this.javaCurrency.getCurrencyCode();
        }

        @Override
        public int getDecimalPrecision() {
            return this.javaCurrency.getDefaultFractionDigits();
        }

        @Override
        public Formatter getFormatter(FormatterOptions formatterOptions) {
            return Formatter.forFiat(this.javaCurrency, formatterOptions);
        }
    }

    private static class CryptoCurrency
    extends Currency {
        private final String currencyCode;
        private final int decimalPrecision;

        CryptoCurrency(String currencyCode, int decimalPrecision) {
            this.currencyCode = currencyCode;
            this.decimalPrecision = decimalPrecision;
        }

        @Override
        public String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public int getDecimalPrecision() {
            return this.decimalPrecision;
        }

        @Override
        public Formatter getFormatter(FormatterOptions formatterOptions) {
            return Formatter.forMoney(this, formatterOptions);
        }
    }
}

