/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.messages.multidevice;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.signal.core.util.stream.LimitedInputStream;
import org.whispersystems.signalservice.api.messages.multidevice.ChunkedInputStream;
import org.whispersystems.signalservice.api.messages.multidevice.DeviceContact;
import org.whispersystems.signalservice.api.messages.multidevice.DeviceContactAvatar;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.internal.push.ContactDetails;
import org.whispersystems.signalservice.internal.util.Util;

public class DeviceContactsInputStream
extends ChunkedInputStream {
    private static final String TAG = DeviceContactsInputStream.class.getSimpleName();

    public DeviceContactsInputStream(InputStream in) {
        super(in);
    }

    public DeviceContact read() throws IOException {
        int detailsLength = (int)this.readRawVarint32();
        if (detailsLength == -1) {
            return null;
        }
        byte[] detailsSerialized = new byte[detailsLength];
        Util.readFully(this.in, detailsSerialized);
        ContactDetails details = (ContactDetails)((Object)ContactDetails.ADAPTER.decode(detailsSerialized));
        Optional<ServiceId.ACI> aci = Optional.ofNullable(ServiceId.ACI.parseOrNull(details.aci));
        Optional<String> e164 = Optional.ofNullable(details.number);
        Optional<String> name = Optional.ofNullable(details.name);
        Optional<DeviceContactAvatar> avatar = Optional.empty();
        Optional<Integer> expireTimer = Optional.empty();
        Optional<Integer> expireTimerVersion = Optional.empty();
        Optional<Integer> inboxPosition = Optional.empty();
        if (details.avatar != null && details.avatar.length != null) {
            long avatarLength = details.avatar.length.intValue();
            LimitedInputStream avatarStream = new LimitedInputStream(this.in, avatarLength);
            String avatarContentType = details.avatar.contentType != null ? details.avatar.contentType : "image/*";
            avatar = Optional.of(new DeviceContactAvatar((InputStream)avatarStream, avatarLength, avatarContentType));
        }
        if (details.expireTimer != null && details.expireTimer > 0) {
            expireTimer = Optional.of(details.expireTimer);
        }
        if (details.expireTimerVersion != null && details.expireTimerVersion > 0) {
            expireTimerVersion = Optional.of(details.expireTimerVersion);
        }
        if (details.inboxPosition != null) {
            inboxPosition = Optional.of(details.inboxPosition);
        }
        if (details.aci == null && details.number == null) {
            if (avatar.isPresent()) {
                ((DeviceContactAvatar)avatar.get()).getInputStream().readAllBytes();
            }
            throw new IOException("Missing contact address!");
        }
        return new DeviceContact(aci, e164, name, avatar, expireTimer, expireTimerVersion, inboxPosition);
    }
}

