/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.messages.calls;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.whispersystems.signalservice.api.messages.calls.AnswerMessage;
import org.whispersystems.signalservice.api.messages.calls.BusyMessage;
import org.whispersystems.signalservice.api.messages.calls.HangupMessage;
import org.whispersystems.signalservice.api.messages.calls.IceUpdateMessage;
import org.whispersystems.signalservice.api.messages.calls.OfferMessage;
import org.whispersystems.signalservice.api.messages.calls.OpaqueMessage;

public class SignalServiceCallMessage {
    private final Optional<OfferMessage> offerMessage;
    private final Optional<AnswerMessage> answerMessage;
    private final Optional<HangupMessage> hangupMessage;
    private final Optional<BusyMessage> busyMessage;
    private final Optional<List<IceUpdateMessage>> iceUpdateMessages;
    private final Optional<OpaqueMessage> opaqueMessage;
    private final Optional<Integer> destinationDeviceId;
    private final Optional<byte[]> groupId;
    private final Optional<Long> timestamp;

    private SignalServiceCallMessage(Optional<OfferMessage> offerMessage, Optional<AnswerMessage> answerMessage, Optional<List<IceUpdateMessage>> iceUpdateMessages, Optional<HangupMessage> hangupMessage, Optional<BusyMessage> busyMessage, Optional<OpaqueMessage> opaqueMessage, Optional<Integer> destinationDeviceId) {
        this(offerMessage, answerMessage, iceUpdateMessages, hangupMessage, busyMessage, opaqueMessage, destinationDeviceId, Optional.empty(), Optional.empty());
    }

    private SignalServiceCallMessage(Optional<OfferMessage> offerMessage, Optional<AnswerMessage> answerMessage, Optional<List<IceUpdateMessage>> iceUpdateMessages, Optional<HangupMessage> hangupMessage, Optional<BusyMessage> busyMessage, Optional<OpaqueMessage> opaqueMessage, Optional<Integer> destinationDeviceId, Optional<byte[]> groupId, Optional<Long> timestamp) {
        this.offerMessage = offerMessage;
        this.answerMessage = answerMessage;
        this.iceUpdateMessages = iceUpdateMessages;
        this.hangupMessage = hangupMessage;
        this.busyMessage = busyMessage;
        this.opaqueMessage = opaqueMessage;
        this.destinationDeviceId = destinationDeviceId;
        this.groupId = groupId;
        this.timestamp = timestamp;
    }

    public static SignalServiceCallMessage forOffer(OfferMessage offerMessage, Integer destinationDeviceId) {
        return new SignalServiceCallMessage(Optional.of(offerMessage), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.ofNullable(destinationDeviceId));
    }

    public static SignalServiceCallMessage forAnswer(AnswerMessage answerMessage, Integer destinationDeviceId) {
        return new SignalServiceCallMessage(Optional.empty(), Optional.of(answerMessage), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.ofNullable(destinationDeviceId));
    }

    public static SignalServiceCallMessage forIceUpdates(List<IceUpdateMessage> iceUpdateMessages, Integer destinationDeviceId) {
        return new SignalServiceCallMessage(Optional.empty(), Optional.empty(), Optional.of(iceUpdateMessages), Optional.empty(), Optional.empty(), Optional.empty(), Optional.ofNullable(destinationDeviceId));
    }

    public static SignalServiceCallMessage forIceUpdate(IceUpdateMessage iceUpdateMessage, Integer destinationDeviceId) {
        LinkedList<IceUpdateMessage> iceUpdateMessages = new LinkedList<IceUpdateMessage>();
        iceUpdateMessages.add(iceUpdateMessage);
        return new SignalServiceCallMessage(Optional.empty(), Optional.empty(), Optional.of(iceUpdateMessages), Optional.empty(), Optional.empty(), Optional.empty(), Optional.ofNullable(destinationDeviceId));
    }

    public static SignalServiceCallMessage forHangup(HangupMessage hangupMessage, Integer destinationDeviceId) {
        return new SignalServiceCallMessage(Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(hangupMessage), Optional.empty(), Optional.empty(), Optional.ofNullable(destinationDeviceId));
    }

    public static SignalServiceCallMessage forBusy(BusyMessage busyMessage, Integer destinationDeviceId) {
        return new SignalServiceCallMessage(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(busyMessage), Optional.empty(), Optional.ofNullable(destinationDeviceId));
    }

    public static SignalServiceCallMessage forOpaque(OpaqueMessage opaqueMessage, Integer destinationDeviceId) {
        return new SignalServiceCallMessage(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(opaqueMessage), Optional.ofNullable(destinationDeviceId));
    }

    public static SignalServiceCallMessage forOutgoingGroupOpaque(byte[] groupId, long timestamp, OpaqueMessage opaqueMessage, Integer destinationDeviceId) {
        return new SignalServiceCallMessage(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(opaqueMessage), Optional.ofNullable(destinationDeviceId), Optional.of(groupId), Optional.of(timestamp));
    }

    public static SignalServiceCallMessage empty() {
        return new SignalServiceCallMessage(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public Optional<List<IceUpdateMessage>> getIceUpdateMessages() {
        return this.iceUpdateMessages;
    }

    public Optional<AnswerMessage> getAnswerMessage() {
        return this.answerMessage;
    }

    public Optional<OfferMessage> getOfferMessage() {
        return this.offerMessage;
    }

    public Optional<HangupMessage> getHangupMessage() {
        return this.hangupMessage;
    }

    public Optional<BusyMessage> getBusyMessage() {
        return this.busyMessage;
    }

    public Optional<OpaqueMessage> getOpaqueMessage() {
        return this.opaqueMessage;
    }

    public Optional<Integer> getDestinationDeviceId() {
        return this.destinationDeviceId;
    }

    public Optional<byte[]> getGroupId() {
        return this.groupId;
    }

    public Optional<Long> getTimestamp() {
        return this.timestamp;
    }

    public boolean isUrgent() {
        return this.offerMessage.isPresent() || this.hangupMessage.isPresent() || this.opaqueMessage.map(m -> m.getUrgency() == OpaqueMessage.Urgency.HANDLE_IMMEDIATELY).orElse(false) != false;
    }
}

