/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.messages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class SignalServiceStickerManifest {
    private final Optional<String> title;
    private final Optional<String> author;
    private final Optional<StickerInfo> cover;
    private final List<StickerInfo> stickers;

    public SignalServiceStickerManifest(String title, String author, StickerInfo cover, List<StickerInfo> stickers) {
        this.title = Optional.ofNullable(title);
        this.author = Optional.ofNullable(author);
        this.cover = Optional.ofNullable(cover);
        this.stickers = stickers == null ? Collections.emptyList() : new ArrayList<StickerInfo>(stickers);
    }

    public Optional<String> getTitle() {
        return this.title;
    }

    public Optional<String> getAuthor() {
        return this.author;
    }

    public Optional<StickerInfo> getCover() {
        return this.cover;
    }

    public List<StickerInfo> getStickers() {
        return this.stickers;
    }

    public static final class StickerInfo {
        private final int id;
        private final String emoji;
        private final String contentType;

        public StickerInfo(int id, String emoji, String contentType) {
            this.id = id;
            this.emoji = emoji;
            this.contentType = contentType;
        }

        public int getId() {
            return this.id;
        }

        public String getEmoji() {
            return this.emoji;
        }

        public String getContentType() {
            return this.contentType;
        }
    }
}

