/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.crypto;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SkippingOutputStream
extends FilterOutputStream {
    private long toSkip;

    public SkippingOutputStream(long toSkip, OutputStream wrapped) {
        super(wrapped);
        this.toSkip = toSkip;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.toSkip > 0L) {
            --this.toSkip;
        } else {
            this.out.write(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || len + off > b.length || len + off < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.toSkip > 0L) {
            if ((long)len <= this.toSkip) {
                this.toSkip -= (long)len;
            } else {
                this.out.write(b, off + (int)this.toSkip, len - (int)this.toSkip);
                this.toSkip = 0L;
            }
        } else {
            this.out.write(b, off, len);
        }
    }
}

