/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.backups;

import java.security.SecureRandom;
import java.time.Instant;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.zkgroup.GenericServerSecretParams;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.backups.BackupAuthCredentialResponse;
import org.signal.libsignal.zkgroup.backups.BackupCredentialType;
import org.signal.libsignal.zkgroup.backups.BackupLevel;
import org.signal.libsignal.zkgroup.internal.ByteArray;

public final class BackupAuthCredentialRequest
extends ByteArray {
    public BackupAuthCredentialRequest(byte[] contents) throws InvalidInputException {
        super(contents);
        FilterExceptions.filterExceptions(InvalidInputException.class, () -> Native.BackupAuthCredentialRequest_CheckValidContents(contents));
    }

    public BackupAuthCredentialResponse issueCredential(Instant timestamp, BackupLevel backupLevel, BackupCredentialType type, GenericServerSecretParams params) {
        return this.issueCredential(timestamp, backupLevel, type, params, new SecureRandom());
    }

    public BackupAuthCredentialResponse issueCredential(Instant timestamp, BackupLevel backupLevel, BackupCredentialType type, GenericServerSecretParams params, SecureRandom secureRandom) {
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        byte[] newContents = Native.BackupAuthCredentialRequest_IssueDeterministic(this.getInternalContentsForJNI(), timestamp.getEpochSecond(), backupLevel.getValue(), type.getValue(), params.getInternalContentsForJNI(), random);
        try {
            return new BackupAuthCredentialResponse(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }
}

