/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.crypto.jce;

import java.security.NoSuchAlgorithmException;
import org.signal.libsignal.crypto.CryptographicHash;

public class MessageDigest {
    CryptographicHash hash;

    public static MessageDigest getInstance(String algoName) throws NoSuchAlgorithmException {
        return new MessageDigest(algoName);
    }

    private MessageDigest(String algoName) throws NoSuchAlgorithmException {
        this.hash = new CryptographicHash(algoName);
    }

    public void update(byte[] input, int offset, int len) {
        this.hash.update(input, offset, len);
    }

    public void update(byte[] input) {
        this.update(input, 0, input.length);
    }

    public byte[] doFinal() {
        return this.hash.finish();
    }

    public byte[] doFinal(byte[] last) {
        this.update(last);
        return this.doFinal();
    }

    public byte[] doFinal(byte[] last, int offset, int len) {
        this.update(last, offset, len);
        return this.doFinal();
    }
}

