// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Amazon S3 key format for log objects. Only one format, PartitionedPrefix or SimplePrefix, is allowed.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct TargetObjectKeyFormat {
    /// <p>To use the simple format for S3 keys for log objects. To specify SimplePrefix format, set SimplePrefix to {}.</p>
    pub simple_prefix: ::std::option::Option<crate::types::SimplePrefix>,
    /// <p>Partitioned S3 key for log objects.</p>
    pub partitioned_prefix: ::std::option::Option<crate::types::PartitionedPrefix>,
}
impl TargetObjectKeyFormat {
    /// <p>To use the simple format for S3 keys for log objects. To specify SimplePrefix format, set SimplePrefix to {}.</p>
    pub fn simple_prefix(&self) -> ::std::option::Option<&crate::types::SimplePrefix> {
        self.simple_prefix.as_ref()
    }
    /// <p>Partitioned S3 key for log objects.</p>
    pub fn partitioned_prefix(&self) -> ::std::option::Option<&crate::types::PartitionedPrefix> {
        self.partitioned_prefix.as_ref()
    }
}
impl TargetObjectKeyFormat {
    /// Creates a new builder-style object to manufacture [`TargetObjectKeyFormat`](crate::types::TargetObjectKeyFormat).
    pub fn builder() -> crate::types::builders::TargetObjectKeyFormatBuilder {
        crate::types::builders::TargetObjectKeyFormatBuilder::default()
    }
}

/// A builder for [`TargetObjectKeyFormat`](crate::types::TargetObjectKeyFormat).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct TargetObjectKeyFormatBuilder {
    pub(crate) simple_prefix: ::std::option::Option<crate::types::SimplePrefix>,
    pub(crate) partitioned_prefix: ::std::option::Option<crate::types::PartitionedPrefix>,
}
impl TargetObjectKeyFormatBuilder {
    /// <p>To use the simple format for S3 keys for log objects. To specify SimplePrefix format, set SimplePrefix to {}.</p>
    pub fn simple_prefix(mut self, input: crate::types::SimplePrefix) -> Self {
        self.simple_prefix = ::std::option::Option::Some(input);
        self
    }
    /// <p>To use the simple format for S3 keys for log objects. To specify SimplePrefix format, set SimplePrefix to {}.</p>
    pub fn set_simple_prefix(mut self, input: ::std::option::Option<crate::types::SimplePrefix>) -> Self {
        self.simple_prefix = input;
        self
    }
    /// <p>To use the simple format for S3 keys for log objects. To specify SimplePrefix format, set SimplePrefix to {}.</p>
    pub fn get_simple_prefix(&self) -> &::std::option::Option<crate::types::SimplePrefix> {
        &self.simple_prefix
    }
    /// <p>Partitioned S3 key for log objects.</p>
    pub fn partitioned_prefix(mut self, input: crate::types::PartitionedPrefix) -> Self {
        self.partitioned_prefix = ::std::option::Option::Some(input);
        self
    }
    /// <p>Partitioned S3 key for log objects.</p>
    pub fn set_partitioned_prefix(mut self, input: ::std::option::Option<crate::types::PartitionedPrefix>) -> Self {
        self.partitioned_prefix = input;
        self
    }
    /// <p>Partitioned S3 key for log objects.</p>
    pub fn get_partitioned_prefix(&self) -> &::std::option::Option<crate::types::PartitionedPrefix> {
        &self.partitioned_prefix
    }
    /// Consumes the builder and constructs a [`TargetObjectKeyFormat`](crate::types::TargetObjectKeyFormat).
    pub fn build(self) -> crate::types::TargetObjectKeyFormat {
        crate::types::TargetObjectKeyFormat {
            simple_prefix: self.simple_prefix,
            partitioned_prefix: self.partitioned_prefix,
        }
    }
}
