// generated by diplomat-tool
import { BidiParagraph } from "./BidiParagraph.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * An object containing bidi information for a given string, produced by `for_text()` on `Bidi`
 *
 * See the [Rust documentation for `BidiInfo`](https://docs.rs/unicode_bidi/latest/unicode_bidi/struct.BidiInfo.html) for more information.
 */
const BidiInfo_box_destroy_registry = new FinalizationRegistry((ptr) => {
    wasm.icu4x_BidiInfo_destroy_mv1(ptr);
});

export class BidiInfo {
    // Internal ptr reference:
    #ptr = null;

    // Lifetimes are only to keep dependencies alive.
    // Since JS won't garbage collect until there are no incoming edges.
    #selfEdge = [];
    #textEdge = [];

    #internalConstructor(symbol, ptr, selfEdge, textEdge) {
        if (symbol !== diplomatRuntime.internalConstructor) {
            console.error("BidiInfo is an Opaque type. You cannot call its constructor.");
            return;
        }
        this.#textEdge = textEdge;
        this.#ptr = ptr;
        this.#selfEdge = selfEdge;

        // Are we being borrowed? If not, we can register.
        if (this.#selfEdge.length === 0) {
            BidiInfo_box_destroy_registry.register(this, this.#ptr);
        }

        return this;
    }
    get ffiValue() {
        return this.#ptr;
    }


    /**
     * The number of paragraphs contained here
     */
    get paragraphCount() {

        const result = wasm.icu4x_BidiInfo_paragraph_count_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Get the nth paragraph, returning `None` if out of bounds
     */
    paragraphAt(n) {
        // This lifetime edge depends on lifetimes 'text
        let textEdges = [this];


        const result = wasm.icu4x_BidiInfo_paragraph_at_mv1(this.ffiValue, n);

        try {
            return result === 0 ? null : new BidiParagraph(diplomatRuntime.internalConstructor, result, [], textEdges);
        }

        finally {
        }
    }

    /**
     * The number of bytes in this full text
     */
    get size() {

        const result = wasm.icu4x_BidiInfo_size_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Get the BIDI level at a particular byte index in the full text.
     * This integer is conceptually a `unicode_bidi::Level`,
     * and can be further inspected using the static methods on Bidi.
     *
     * Returns 0 (equivalent to `Level::ltr()`) on error
     */
    levelAt(pos) {

        const result = wasm.icu4x_BidiInfo_level_at_mv1(this.ffiValue, pos);

        try {
            return result;
        }

        finally {
        }
    }

    constructor(symbol, ptr, selfEdge, textEdge) {
        return this.#internalConstructor(...arguments)
    }
}