//! @file a68g-lib.h
//! @author J. Marcel van der Veer

//! @section Copyright
//!
//! This file is part of Algol68G - an Algol 68 compiler-interpreter.
//! Copyright 2001-2025 J. Marcel van der Veer [algol68g@xs4all.nl].

//! @section License
//!
//! This program is free software; you can redistribute it and/or modify it 
//! under the terms of the GNU General Public License as published by the 
//! Free Software Foundation; either version 3 of the License, or 
//! (at your option) any later version.
//!
//! This program is distributed in the hope that it will be useful, but 
//! WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
//! or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
//! more details. You should have received a copy of the GNU General Public 
//! License along with this program. If not, see [http://www.gnu.org/licenses/].

//! @section Synopsis
//!
//! Internal math routines.

#if !defined (__A68G_LIB_H__)
#define __A68G_LIB_H__

#define A68G_INVALID(c)\
  if (c) {\
    errno = EDOM;\
    return 0;\
  }

#define A68G_OVERFLOW(c)\
  if (c) {\
    errno = ERANGE;\
    return 0;\
  }

#define A68G_MAX_FAC 170

INT_T a68g_add_int (INT_T, INT_T);
INT_T a68g_mod_int (INT_T, INT_T);
INT_T a68g_mul_int (INT_T, INT_T);
INT_T a68g_m_up_n (INT_T, INT_T);
INT_T a68g_over_int (INT_T, INT_T);
INT_T a68g_round (REAL_T);
INT_T a68g_sub_int (INT_T, INT_T);
REAL_T a68g_abs_real (REAL_T);
REAL_T a68g_acosdg_real (REAL_T);
REAL_T a68g_acosh_real (REAL_T);
REAL_T a68g_acotdg_real (REAL_T);
REAL_T a68g_acot_real (REAL_T);
REAL_T a68g_acsc_real (REAL_T);
REAL_T a68g_acscdg_real (REAL_T);
REAL_T a68g_asec_real (REAL_T);
REAL_T a68g_asecdg_real (REAL_T);
REAL_T a68g_asindg_real (REAL_T);
REAL_T a68g_asinh_real (REAL_T);
REAL_T a68g_atan2_real (REAL_T, REAL_T);
REAL_T a68g_atandg_real (REAL_T);
REAL_T a68g_atanh_real (REAL_T);
REAL_T a68g_beta_real (REAL_T, REAL_T);
REAL_T a68g_choose_real (INT_T, INT_T);
REAL_T a68g_cas_real (REAL_T);
REAL_T a68g_cosdg_real (REAL_T);
REAL_T a68g_cospi_real (REAL_T);
REAL_T a68g_cot_realdg_real (REAL_T);
REAL_T a68g_cot_realpi (REAL_T);
REAL_T a68g_cot_real (REAL_T);
REAL_T a68g_csc_real (REAL_T);
REAL_T a68g_cscdg_real (REAL_T);
REAL_T a68g_sec_real (REAL_T);
REAL_T a68g_secdg_real (REAL_T);
REAL_T a68g_div_int (INT_T, INT_T);
REAL_T a68g_exp_real (REAL_T);
REAL_T a68g_fact_real (INT_T);
REAL_T a68g_fdiv_real (REAL_T, REAL_T);
REAL_T a68g_hypot_real (REAL_T, REAL_T);
REAL_T a68g_int_real (REAL_T);
REAL_T a68g_inverfc_real (REAL_T);
REAL_T a68g_inverf_real (REAL_T);
REAL_T a68g_ln1p_real (REAL_T);
REAL_T a68g_ln1p_real (REAL_T);
REAL_T a68g_ln_beta_real (REAL_T, REAL_T);
REAL_T a68g_ln_choose_real (INT_T, INT_T);
REAL_T a68g_ln_fact_real (INT_T);
REAL_T a68g_ln_real (REAL_T);
REAL_T a68g_mininf_real (void);
REAL_T a68g_max_real (REAL_T, REAL_T);
REAL_T a68g_min_real (REAL_T, REAL_T);
REAL_T a68g_nan_real (void);
REAL_T a68g_neginf_double_real (void);
REAL_T a68g_posinf_real (void);
REAL_T a68g_psi_real (REAL_T);
REAL_T a68g_sign_real (REAL_T);
REAL_T a68g_sindg_real (REAL_T);
REAL_T a68g_sinpi_real (REAL_T);
REAL_T a68g_tandg_real (REAL_T);
REAL_T a68g_tanpi_real (REAL_T);
REAL_T a68g_x_up_n_real (REAL_T, INT_T);
REAL_T a68g_x_up_y (REAL_T, REAL_T);
REAL_T a68g_beta_inc_real (REAL_T, REAL_T, REAL_T);
DOUBLE_T a68g_beta_inc_double (DOUBLE_T, DOUBLE_T, DOUBLE_T);
DOUBLE_T a68g_cot_double (DOUBLE_T);
DOUBLE_T a68g_csc_double (DOUBLE_T);
DOUBLE_T a68g_cscdg_double (DOUBLE_T);
DOUBLE_T a68g_sec_double (DOUBLE_T);
DOUBLE_T a68g_secdg_double (DOUBLE_T);
DOUBLE_T a68g_acot_double (DOUBLE_T);
DOUBLE_T a68g_acsc_double (DOUBLE_T);
DOUBLE_T a68g_acscdg_double (DOUBLE_T);
DOUBLE_T a68g_asec_double (DOUBLE_T);
DOUBLE_T a68g_asecdg_double (DOUBLE_T);
DOUBLE_T a68g_sindg_double (DOUBLE_T);
DOUBLE_T a68g_cas_double (DOUBLE_T);
DOUBLE_T a68g_cosdg_double (DOUBLE_T);
DOUBLE_T a68g_tandg_double (DOUBLE_T);
DOUBLE_T a68g_asindg_double (DOUBLE_T);
DOUBLE_T a68g_acosdg_double (DOUBLE_T);
DOUBLE_T a68g_atandg_double (DOUBLE_T);
DOUBLE_T a68g_cotdg_double (DOUBLE_T);
DOUBLE_T a68g_acotdg_double (DOUBLE_T);
DOUBLE_T a68g_sinpi_double (DOUBLE_T); 
DOUBLE_T a68g_cospi_double (DOUBLE_T); 
DOUBLE_T a68g_tanpi_double (DOUBLE_T);
DOUBLE_T a68g_cotpi_double (DOUBLE_T);

#endif
