use crate::FT_UShort;

pub const TT_PLATFORM_APPLE_UNICODE: FT_UShort = 0;
pub const TT_PLATFORM_MACINTOSH: FT_UShort = 1;
pub const TT_PLATFORM_ISO: FT_UShort = 2; /* deprecated */
pub const TT_PLATFORM_MICROSOFT: FT_UShort = 3;
pub const TT_PLATFORM_CUSTOM: FT_UShort = 4;
pub const TT_PLATFORM_ADOBE: FT_UShort = 7; /* artificial */

pub const TT_APPLE_ID_DEFAULT: FT_UShort = 0; /* Unicode 1.0                   */
pub const TT_APPLE_ID_UNICODE_1_1: FT_UShort = 1; /* specify Hangul at U+34xx      */
pub const TT_APPLE_ID_ISO_10646: FT_UShort = 2; /* deprecated                    */
pub const TT_APPLE_ID_UNICODE_2_0: FT_UShort = 3; /* or later                      */
pub const TT_APPLE_ID_UNICODE_32: FT_UShort = 4; /* 2.0 or later, full repertoire */
pub const TT_APPLE_ID_VARIANT_SELECTOR: FT_UShort = 5; /* variation selector data       */
pub const TT_APPLE_ID_FULL_UNICODE: FT_UShort = 6; /* used with type 13 cmaps       */

pub const TT_MAC_ID_ROMAN: FT_UShort = 0;
pub const TT_MAC_ID_JAPANESE: FT_UShort = 1;
pub const TT_MAC_ID_TRADITIONAL_CHINESE: FT_UShort = 2;
pub const TT_MAC_ID_KOREAN: FT_UShort = 3;
pub const TT_MAC_ID_ARABIC: FT_UShort = 4;
pub const TT_MAC_ID_HEBREW: FT_UShort = 5;
pub const TT_MAC_ID_GREEK: FT_UShort = 6;
pub const TT_MAC_ID_RUSSIAN: FT_UShort = 7;
pub const TT_MAC_ID_RSYMBOL: FT_UShort = 8;
pub const TT_MAC_ID_DEVANAGARI: FT_UShort = 9;
pub const TT_MAC_ID_GURMUKHI: FT_UShort = 10;
pub const TT_MAC_ID_GUJARATI: FT_UShort = 11;
pub const TT_MAC_ID_ORIYA: FT_UShort = 12;
pub const TT_MAC_ID_BENGALI: FT_UShort = 13;
pub const TT_MAC_ID_TAMIL: FT_UShort = 14;
pub const TT_MAC_ID_TELUGU: FT_UShort = 15;
pub const TT_MAC_ID_KANNADA: FT_UShort = 16;
pub const TT_MAC_ID_MALAYALAM: FT_UShort = 17;
pub const TT_MAC_ID_SINHALESE: FT_UShort = 18;
pub const TT_MAC_ID_BURMESE: FT_UShort = 19;
pub const TT_MAC_ID_KHMER: FT_UShort = 20;
pub const TT_MAC_ID_THAI: FT_UShort = 21;
pub const TT_MAC_ID_LAOTIAN: FT_UShort = 22;
pub const TT_MAC_ID_GEORGIAN: FT_UShort = 23;
pub const TT_MAC_ID_ARMENIAN: FT_UShort = 24;
pub const TT_MAC_ID_MALDIVIAN: FT_UShort = 25;
pub const TT_MAC_ID_SIMPLIFIED_CHINESE: FT_UShort = 25;
pub const TT_MAC_ID_TIBETAN: FT_UShort = 26;
pub const TT_MAC_ID_MONGOLIAN: FT_UShort = 27;
pub const TT_MAC_ID_GEEZ: FT_UShort = 28;
pub const TT_MAC_ID_SLAVIC: FT_UShort = 29;
pub const TT_MAC_ID_VIETNAMESE: FT_UShort = 30;
pub const TT_MAC_ID_SINDHI: FT_UShort = 31;
pub const TT_MAC_ID_UNINTERP: FT_UShort = 32;

pub const TT_ISO_ID_7BIT_ASCII: FT_UShort = 0;
pub const TT_ISO_ID_10646: FT_UShort = 1;
pub const TT_ISO_ID_8859_1: FT_UShort = 2;
pub const TT_MS_ID_SYMBOL_CS: FT_UShort = 0;
pub const TT_MS_ID_UNICODE_CS: FT_UShort = 1;
pub const TT_MS_ID_SJIS: FT_UShort = 2;
pub const TT_MS_ID_PRC: FT_UShort = 3;
pub const TT_MS_ID_BIG_5: FT_UShort = 4;
pub const TT_MS_ID_WANSUNG: FT_UShort = 5;
pub const TT_MS_ID_JOHAB: FT_UShort = 6;
pub const TT_MS_ID_UCS_4: FT_UShort = 10;

pub const TT_ADOBE_ID_STANDARD: FT_UShort = 0;
pub const TT_ADOBE_ID_EXPERT: FT_UShort = 1;
pub const TT_ADOBE_ID_CUSTOM: FT_UShort = 2;
pub const TT_ADOBE_ID_LATIN_1: FT_UShort = 3;

pub const TT_MAC_LANGID_ENGLISH: FT_UShort = 0;
pub const TT_MAC_LANGID_FRENCH: FT_UShort = 1;
pub const TT_MAC_LANGID_GERMAN: FT_UShort = 2;
pub const TT_MAC_LANGID_ITALIAN: FT_UShort = 3;
pub const TT_MAC_LANGID_DUTCH: FT_UShort = 4;
pub const TT_MAC_LANGID_SWEDISH: FT_UShort = 5;
pub const TT_MAC_LANGID_SPANISH: FT_UShort = 6;
pub const TT_MAC_LANGID_DANISH: FT_UShort = 7;
pub const TT_MAC_LANGID_PORTUGUESE: FT_UShort = 8;
pub const TT_MAC_LANGID_NORWEGIAN: FT_UShort = 9;
pub const TT_MAC_LANGID_HEBREW: FT_UShort = 10;
pub const TT_MAC_LANGID_JAPANESE: FT_UShort = 11;
pub const TT_MAC_LANGID_ARABIC: FT_UShort = 12;
pub const TT_MAC_LANGID_FINNISH: FT_UShort = 13;
pub const TT_MAC_LANGID_GREEK: FT_UShort = 14;
pub const TT_MAC_LANGID_ICELANDIC: FT_UShort = 15;
pub const TT_MAC_LANGID_MALTESE: FT_UShort = 16;
pub const TT_MAC_LANGID_TURKISH: FT_UShort = 17;
pub const TT_MAC_LANGID_CROATIAN: FT_UShort = 18;
pub const TT_MAC_LANGID_CHINESE_TRADITIONAL: FT_UShort = 19;
pub const TT_MAC_LANGID_URDU: FT_UShort = 20;
pub const TT_MAC_LANGID_HINDI: FT_UShort = 21;
pub const TT_MAC_LANGID_THAI: FT_UShort = 22;
pub const TT_MAC_LANGID_KOREAN: FT_UShort = 23;
pub const TT_MAC_LANGID_LITHUANIAN: FT_UShort = 24;
pub const TT_MAC_LANGID_POLISH: FT_UShort = 25;
pub const TT_MAC_LANGID_HUNGARIAN: FT_UShort = 26;
pub const TT_MAC_LANGID_ESTONIAN: FT_UShort = 27;
pub const TT_MAC_LANGID_LETTISH: FT_UShort = 28;
pub const TT_MAC_LANGID_SAAMISK: FT_UShort = 29;
pub const TT_MAC_LANGID_FAEROESE: FT_UShort = 30;
pub const TT_MAC_LANGID_FARSI: FT_UShort = 31;
pub const TT_MAC_LANGID_RUSSIAN: FT_UShort = 32;
pub const TT_MAC_LANGID_CHINESE_SIMPLIFIED: FT_UShort = 33;
pub const TT_MAC_LANGID_FLEMISH: FT_UShort = 34;
pub const TT_MAC_LANGID_IRISH: FT_UShort = 35;
pub const TT_MAC_LANGID_ALBANIAN: FT_UShort = 36;
pub const TT_MAC_LANGID_ROMANIAN: FT_UShort = 37;
pub const TT_MAC_LANGID_CZECH: FT_UShort = 38;
pub const TT_MAC_LANGID_SLOVAK: FT_UShort = 39;
pub const TT_MAC_LANGID_SLOVENIAN: FT_UShort = 40;
pub const TT_MAC_LANGID_YIDDISH: FT_UShort = 41;
pub const TT_MAC_LANGID_SERBIAN: FT_UShort = 42;
pub const TT_MAC_LANGID_MACEDONIAN: FT_UShort = 43;
pub const TT_MAC_LANGID_BULGARIAN: FT_UShort = 44;
pub const TT_MAC_LANGID_UKRAINIAN: FT_UShort = 45;
pub const TT_MAC_LANGID_BYELORUSSIAN: FT_UShort = 46;
pub const TT_MAC_LANGID_UZBEK: FT_UShort = 47;
pub const TT_MAC_LANGID_KAZAKH: FT_UShort = 48;
pub const TT_MAC_LANGID_AZERBAIJANI: FT_UShort = 49;
pub const TT_MAC_LANGID_AZERBAIJANI_CYRILLIC_SCRIPT: FT_UShort = 49;
pub const TT_MAC_LANGID_AZERBAIJANI_ARABIC_SCRIPT: FT_UShort = 50;
pub const TT_MAC_LANGID_ARMENIAN: FT_UShort = 51;
pub const TT_MAC_LANGID_GEORGIAN: FT_UShort = 52;
pub const TT_MAC_LANGID_MOLDAVIAN: FT_UShort = 53;
pub const TT_MAC_LANGID_KIRGHIZ: FT_UShort = 54;
pub const TT_MAC_LANGID_TAJIKI: FT_UShort = 55;
pub const TT_MAC_LANGID_TURKMEN: FT_UShort = 56;
pub const TT_MAC_LANGID_MONGOLIAN: FT_UShort = 57;
pub const TT_MAC_LANGID_MONGOLIAN_MONGOLIAN_SCRIPT: FT_UShort = 57;
pub const TT_MAC_LANGID_MONGOLIAN_CYRILLIC_SCRIPT: FT_UShort = 58;
pub const TT_MAC_LANGID_PASHTO: FT_UShort = 59;
pub const TT_MAC_LANGID_KURDISH: FT_UShort = 60;
pub const TT_MAC_LANGID_KASHMIRI: FT_UShort = 61;
pub const TT_MAC_LANGID_SINDHI: FT_UShort = 62;
pub const TT_MAC_LANGID_TIBETAN: FT_UShort = 63;
pub const TT_MAC_LANGID_NEPALI: FT_UShort = 64;
pub const TT_MAC_LANGID_SANSKRIT: FT_UShort = 65;
pub const TT_MAC_LANGID_MARATHI: FT_UShort = 66;
pub const TT_MAC_LANGID_BENGALI: FT_UShort = 67;
pub const TT_MAC_LANGID_ASSAMESE: FT_UShort = 68;
pub const TT_MAC_LANGID_GUJARATI: FT_UShort = 69;
pub const TT_MAC_LANGID_PUNJABI: FT_UShort = 70;
pub const TT_MAC_LANGID_ORIYA: FT_UShort = 71;
pub const TT_MAC_LANGID_MALAYALAM: FT_UShort = 72;
pub const TT_MAC_LANGID_KANNADA: FT_UShort = 73;
pub const TT_MAC_LANGID_TAMIL: FT_UShort = 74;
pub const TT_MAC_LANGID_TELUGU: FT_UShort = 75;
pub const TT_MAC_LANGID_SINHALESE: FT_UShort = 76;
pub const TT_MAC_LANGID_BURMESE: FT_UShort = 77;
pub const TT_MAC_LANGID_KHMER: FT_UShort = 78;
pub const TT_MAC_LANGID_LAO: FT_UShort = 79;
pub const TT_MAC_LANGID_VIETNAMESE: FT_UShort = 80;
pub const TT_MAC_LANGID_INDONESIAN: FT_UShort = 81;
pub const TT_MAC_LANGID_TAGALOG: FT_UShort = 82;
pub const TT_MAC_LANGID_MALAY_ROMAN_SCRIPT: FT_UShort = 83;
pub const TT_MAC_LANGID_MALAY_ARABIC_SCRIPT: FT_UShort = 84;
pub const TT_MAC_LANGID_AMHARIC: FT_UShort = 85;
pub const TT_MAC_LANGID_TIGRINYA: FT_UShort = 86;
pub const TT_MAC_LANGID_GALLA: FT_UShort = 87;
pub const TT_MAC_LANGID_SOMALI: FT_UShort = 88;
pub const TT_MAC_LANGID_SWAHILI: FT_UShort = 89;
pub const TT_MAC_LANGID_RUANDA: FT_UShort = 90;
pub const TT_MAC_LANGID_RUNDI: FT_UShort = 91;
pub const TT_MAC_LANGID_CHEWA: FT_UShort = 92;
pub const TT_MAC_LANGID_MALAGASY: FT_UShort = 93;
pub const TT_MAC_LANGID_ESPERANTO: FT_UShort = 94;
pub const TT_MAC_LANGID_WELSH: FT_UShort = 128;
pub const TT_MAC_LANGID_BASQUE: FT_UShort = 129;
pub const TT_MAC_LANGID_CATALAN: FT_UShort = 130;
pub const TT_MAC_LANGID_LATIN: FT_UShort = 131;
pub const TT_MAC_LANGID_QUECHUA: FT_UShort = 132;
pub const TT_MAC_LANGID_GUARANI: FT_UShort = 133;
pub const TT_MAC_LANGID_AYMARA: FT_UShort = 134;
pub const TT_MAC_LANGID_TATAR: FT_UShort = 135;
pub const TT_MAC_LANGID_UIGHUR: FT_UShort = 136;
pub const TT_MAC_LANGID_DZONGKHA: FT_UShort = 137;
pub const TT_MAC_LANGID_JAVANESE: FT_UShort = 138;
pub const TT_MAC_LANGID_SUNDANESE: FT_UShort = 139;

/* The following codes are new as of 2000-03-10 */
pub const TT_MAC_LANGID_GALICIAN: FT_UShort = 140;
pub const TT_MAC_LANGID_AFRIKAANS: FT_UShort = 141;
pub const TT_MAC_LANGID_BRETON: FT_UShort = 142;
pub const TT_MAC_LANGID_INUKTITUT: FT_UShort = 143;
pub const TT_MAC_LANGID_SCOTTISH_GAELIC: FT_UShort = 144;
pub const TT_MAC_LANGID_MANX_GAELIC: FT_UShort = 145;
pub const TT_MAC_LANGID_IRISH_GAELIC: FT_UShort = 146;
pub const TT_MAC_LANGID_TONGAN: FT_UShort = 147;
pub const TT_MAC_LANGID_GREEK_POLYTONIC: FT_UShort = 148;
pub const TT_MAC_LANGID_GREELANDIC: FT_UShort = 149;
pub const TT_MAC_LANGID_AZERBAIJANI_ROMAN_SCRIPT: FT_UShort = 150;

pub const TT_MS_LANGID_ARABIC_SAUDI_ARABIA: FT_UShort = 0x0401;
pub const TT_MS_LANGID_ARABIC_IRAQ: FT_UShort = 0x0801;
pub const TT_MS_LANGID_ARABIC_EGYPT: FT_UShort = 0x0C01;
pub const TT_MS_LANGID_ARABIC_LIBYA: FT_UShort = 0x1001;
pub const TT_MS_LANGID_ARABIC_ALGERIA: FT_UShort = 0x1401;
pub const TT_MS_LANGID_ARABIC_MOROCCO: FT_UShort = 0x1801;
pub const TT_MS_LANGID_ARABIC_TUNISIA: FT_UShort = 0x1C01;
pub const TT_MS_LANGID_ARABIC_OMAN: FT_UShort = 0x2001;
pub const TT_MS_LANGID_ARABIC_YEMEN: FT_UShort = 0x2401;
pub const TT_MS_LANGID_ARABIC_SYRIA: FT_UShort = 0x2801;
pub const TT_MS_LANGID_ARABIC_JORDAN: FT_UShort = 0x2C01;
pub const TT_MS_LANGID_ARABIC_LEBANON: FT_UShort = 0x3001;
pub const TT_MS_LANGID_ARABIC_KUWAIT: FT_UShort = 0x3401;
pub const TT_MS_LANGID_ARABIC_UAE: FT_UShort = 0x3801;
pub const TT_MS_LANGID_ARABIC_BAHRAIN: FT_UShort = 0x3C01;
pub const TT_MS_LANGID_ARABIC_QATAR: FT_UShort = 0x4001;
pub const TT_MS_LANGID_BULGARIAN_BULGARIA: FT_UShort = 0x0402;
pub const TT_MS_LANGID_CATALAN_CATALAN: FT_UShort = 0x0403;
pub const TT_MS_LANGID_CHINESE_TAIWAN: FT_UShort = 0x0404;
pub const TT_MS_LANGID_CHINESE_PRC: FT_UShort = 0x0804;
pub const TT_MS_LANGID_CHINESE_HONG_KONG: FT_UShort = 0x0C04;
pub const TT_MS_LANGID_CHINESE_SINGAPORE: FT_UShort = 0x1004;
pub const TT_MS_LANGID_CHINESE_MACAO: FT_UShort = 0x1404;
pub const TT_MS_LANGID_CZECH_CZECH_REPUBLIC: FT_UShort = 0x0405;
pub const TT_MS_LANGID_DANISH_DENMARK: FT_UShort = 0x0406;
pub const TT_MS_LANGID_GERMAN_GERMANY: FT_UShort = 0x0407;
pub const TT_MS_LANGID_GERMAN_SWITZERLAND: FT_UShort = 0x0807;
pub const TT_MS_LANGID_GERMAN_AUSTRIA: FT_UShort = 0x0C07;
pub const TT_MS_LANGID_GERMAN_LUXEMBOURG: FT_UShort = 0x1007;
pub const TT_MS_LANGID_GERMAN_LIECHTENSTEIN: FT_UShort = 0x1407;
pub const TT_MS_LANGID_GREEK_GREECE: FT_UShort = 0x0408;
pub const TT_MS_LANGID_ENGLISH_UNITED_STATES: FT_UShort = 0x0409;
pub const TT_MS_LANGID_ENGLISH_UNITED_KINGDOM: FT_UShort = 0x0809;
pub const TT_MS_LANGID_ENGLISH_AUSTRALIA: FT_UShort = 0x0C09;
pub const TT_MS_LANGID_ENGLISH_CANADA: FT_UShort = 0x1009;
pub const TT_MS_LANGID_ENGLISH_NEW_ZEALAND: FT_UShort = 0x1409;
pub const TT_MS_LANGID_ENGLISH_IRELAND: FT_UShort = 0x1809;
pub const TT_MS_LANGID_ENGLISH_SOUTH_AFRICA: FT_UShort = 0x1C09;
pub const TT_MS_LANGID_ENGLISH_JAMAICA: FT_UShort = 0x2009;
pub const TT_MS_LANGID_ENGLISH_CARIBBEAN: FT_UShort = 0x2409;
pub const TT_MS_LANGID_ENGLISH_BELIZE: FT_UShort = 0x2809;
pub const TT_MS_LANGID_ENGLISH_TRINIDAD: FT_UShort = 0x2C09;
pub const TT_MS_LANGID_ENGLISH_ZIMBABWE: FT_UShort = 0x3009;
pub const TT_MS_LANGID_ENGLISH_PHILIPPINES: FT_UShort = 0x3409;
pub const TT_MS_LANGID_ENGLISH_INDIA: FT_UShort = 0x4009;
pub const TT_MS_LANGID_ENGLISH_MALAYSIA: FT_UShort = 0x4409;
pub const TT_MS_LANGID_ENGLISH_SINGAPORE: FT_UShort = 0x4809;
pub const TT_MS_LANGID_SPANISH_SPAIN_TRADITIONAL_SORT: FT_UShort = 0x040A;
pub const TT_MS_LANGID_SPANISH_MEXICO: FT_UShort = 0x080A;
pub const TT_MS_LANGID_SPANISH_SPAIN_MODERN_SORT: FT_UShort = 0x0C0A;
pub const TT_MS_LANGID_SPANISH_GUATEMALA: FT_UShort = 0x100A;
pub const TT_MS_LANGID_SPANISH_COSTA_RICA: FT_UShort = 0x140A;
pub const TT_MS_LANGID_SPANISH_PANAMA: FT_UShort = 0x180A;
pub const TT_MS_LANGID_SPANISH_DOMINICAN_REPUBLIC: FT_UShort = 0x1C0A;
pub const TT_MS_LANGID_SPANISH_VENEZUELA: FT_UShort = 0x200A;
pub const TT_MS_LANGID_SPANISH_COLOMBIA: FT_UShort = 0x240A;
pub const TT_MS_LANGID_SPANISH_PERU: FT_UShort = 0x280A;
pub const TT_MS_LANGID_SPANISH_ARGENTINA: FT_UShort = 0x2C0A;
pub const TT_MS_LANGID_SPANISH_ECUADOR: FT_UShort = 0x300A;
pub const TT_MS_LANGID_SPANISH_CHILE: FT_UShort = 0x340A;
pub const TT_MS_LANGID_SPANISH_URUGUAY: FT_UShort = 0x380A;
pub const TT_MS_LANGID_SPANISH_PARAGUAY: FT_UShort = 0x3C0A;
pub const TT_MS_LANGID_SPANISH_BOLIVIA: FT_UShort = 0x400A;
pub const TT_MS_LANGID_SPANISH_EL_SALVADOR: FT_UShort = 0x440A;
pub const TT_MS_LANGID_SPANISH_HONDURAS: FT_UShort = 0x480A;
pub const TT_MS_LANGID_SPANISH_NICARAGUA: FT_UShort = 0x4C0A;
pub const TT_MS_LANGID_SPANISH_PUERTO_RICO: FT_UShort = 0x500A;
pub const TT_MS_LANGID_SPANISH_UNITED_STATES: FT_UShort = 0x540A;
pub const TT_MS_LANGID_FINNISH_FINLAND: FT_UShort = 0x040B;
pub const TT_MS_LANGID_FRENCH_FRANCE: FT_UShort = 0x040C;
pub const TT_MS_LANGID_FRENCH_BELGIUM: FT_UShort = 0x080C;
pub const TT_MS_LANGID_FRENCH_CANADA: FT_UShort = 0x0C0C;
pub const TT_MS_LANGID_FRENCH_SWITZERLAND: FT_UShort = 0x100C;
pub const TT_MS_LANGID_FRENCH_LUXEMBOURG: FT_UShort = 0x140C;
pub const TT_MS_LANGID_FRENCH_MONACO: FT_UShort = 0x180C;
pub const TT_MS_LANGID_HEBREW_ISRAEL: FT_UShort = 0x040D;
pub const TT_MS_LANGID_HUNGARIAN_HUNGARY: FT_UShort = 0x040E;
pub const TT_MS_LANGID_ICELANDIC_ICELAND: FT_UShort = 0x040F;
pub const TT_MS_LANGID_ITALIAN_ITALY: FT_UShort = 0x0410;
pub const TT_MS_LANGID_ITALIAN_SWITZERLAND: FT_UShort = 0x0810;
pub const TT_MS_LANGID_JAPANESE_JAPAN: FT_UShort = 0x0411;
pub const TT_MS_LANGID_KOREAN_KOREA: FT_UShort = 0x0412;
pub const TT_MS_LANGID_DUTCH_NETHERLANDS: FT_UShort = 0x0413;
pub const TT_MS_LANGID_DUTCH_BELGIUM: FT_UShort = 0x0813;
pub const TT_MS_LANGID_NORWEGIAN_NORWAY_BOKMAL: FT_UShort = 0x0414;
pub const TT_MS_LANGID_NORWEGIAN_NORWAY_NYNORSK: FT_UShort = 0x0814;
pub const TT_MS_LANGID_POLISH_POLAND: FT_UShort = 0x0415;
pub const TT_MS_LANGID_PORTUGUESE_BRAZIL: FT_UShort = 0x0416;
pub const TT_MS_LANGID_PORTUGUESE_PORTUGAL: FT_UShort = 0x0816;
pub const TT_MS_LANGID_ROMANSH_SWITZERLAND: FT_UShort = 0x0417;
pub const TT_MS_LANGID_ROMANIAN_ROMANIA: FT_UShort = 0x0418;
pub const TT_MS_LANGID_RUSSIAN_RUSSIA: FT_UShort = 0x0419;
pub const TT_MS_LANGID_CROATIAN_CROATIA: FT_UShort = 0x041A;
pub const TT_MS_LANGID_SERBIAN_SERBIA_LATIN: FT_UShort = 0x081A;
pub const TT_MS_LANGID_SERBIAN_SERBIA_CYRILLIC: FT_UShort = 0x0C1A;
pub const TT_MS_LANGID_CROATIAN_BOSNIA_HERZEGOVINA: FT_UShort = 0x101A;
pub const TT_MS_LANGID_BOSNIAN_BOSNIA_HERZEGOVINA: FT_UShort = 0x141A;
pub const TT_MS_LANGID_SERBIAN_BOSNIA_HERZ_LATIN: FT_UShort = 0x181A;
pub const TT_MS_LANGID_SERBIAN_BOSNIA_HERZ_CYRILLIC: FT_UShort = 0x1C1A;
pub const TT_MS_LANGID_BOSNIAN_BOSNIA_HERZ_CYRILLIC: FT_UShort = 0x201A;
pub const TT_MS_LANGID_SLOVAK_SLOVAKIA: FT_UShort = 0x041B;
pub const TT_MS_LANGID_ALBANIAN_ALBANIA: FT_UShort = 0x041C;
pub const TT_MS_LANGID_SWEDISH_SWEDEN: FT_UShort = 0x041D;
pub const TT_MS_LANGID_SWEDISH_FINLAND: FT_UShort = 0x081D;
pub const TT_MS_LANGID_THAI_THAILAND: FT_UShort = 0x041E;
pub const TT_MS_LANGID_TURKISH_TURKEY: FT_UShort = 0x041F;
pub const TT_MS_LANGID_URDU_PAKISTAN: FT_UShort = 0x0420;
pub const TT_MS_LANGID_INDONESIAN_INDONESIA: FT_UShort = 0x0421;
pub const TT_MS_LANGID_UKRAINIAN_UKRAINE: FT_UShort = 0x0422;
pub const TT_MS_LANGID_BELARUSIAN_BELARUS: FT_UShort = 0x0423;
pub const TT_MS_LANGID_SLOVENIAN_SLOVENIA: FT_UShort = 0x0424;
pub const TT_MS_LANGID_ESTONIAN_ESTONIA: FT_UShort = 0x0425;
pub const TT_MS_LANGID_LATVIAN_LATVIA: FT_UShort = 0x0426;
pub const TT_MS_LANGID_LITHUANIAN_LITHUANIA: FT_UShort = 0x0427;
pub const TT_MS_LANGID_TAJIK_TAJIKISTAN: FT_UShort = 0x0428;
pub const TT_MS_LANGID_VIETNAMESE_VIET_NAM: FT_UShort = 0x042A;
pub const TT_MS_LANGID_ARMENIAN_ARMENIA: FT_UShort = 0x042B;
pub const TT_MS_LANGID_AZERI_AZERBAIJAN_LATIN: FT_UShort = 0x042C;
pub const TT_MS_LANGID_AZERI_AZERBAIJAN_CYRILLIC: FT_UShort = 0x082C;
pub const TT_MS_LANGID_BASQUE_BASQUE: FT_UShort = 0x042D;
pub const TT_MS_LANGID_UPPER_SORBIAN_GERMANY: FT_UShort = 0x042E;
pub const TT_MS_LANGID_LOWER_SORBIAN_GERMANY: FT_UShort = 0x082E;
pub const TT_MS_LANGID_MACEDONIAN_MACEDONIA: FT_UShort = 0x042F;
pub const TT_MS_LANGID_SETSWANA_SOUTH_AFRICA: FT_UShort = 0x0432;
pub const TT_MS_LANGID_ISIXHOSA_SOUTH_AFRICA: FT_UShort = 0x0434;
pub const TT_MS_LANGID_ISIZULU_SOUTH_AFRICA: FT_UShort = 0x0435;
pub const TT_MS_LANGID_AFRIKAANS_SOUTH_AFRICA: FT_UShort = 0x0436;
pub const TT_MS_LANGID_GEORGIAN_GEORGIA: FT_UShort = 0x0437;
pub const TT_MS_LANGID_FAEROESE_FAEROE_ISLANDS: FT_UShort = 0x0438;
pub const TT_MS_LANGID_HINDI_INDIA: FT_UShort = 0x0439;
pub const TT_MS_LANGID_MALTESE_MALTA: FT_UShort = 0x043A;
pub const TT_MS_LANGID_SAMI_NORTHERN_NORWAY: FT_UShort = 0x043B;
pub const TT_MS_LANGID_SAMI_NORTHERN_SWEDEN: FT_UShort = 0x083B;
pub const TT_MS_LANGID_SAMI_NORTHERN_FINLAND: FT_UShort = 0x0C3B;
pub const TT_MS_LANGID_SAMI_LULE_NORWAY: FT_UShort = 0x103B;
pub const TT_MS_LANGID_SAMI_LULE_SWEDEN: FT_UShort = 0x143B;
pub const TT_MS_LANGID_SAMI_SOUTHERN_NORWAY: FT_UShort = 0x183B;
pub const TT_MS_LANGID_SAMI_SOUTHERN_SWEDEN: FT_UShort = 0x1C3B;
pub const TT_MS_LANGID_SAMI_SKOLT_FINLAND: FT_UShort = 0x203B;
pub const TT_MS_LANGID_SAMI_INARI_FINLAND: FT_UShort = 0x243B;
pub const TT_MS_LANGID_IRISH_IRELAND: FT_UShort = 0x083C;
pub const TT_MS_LANGID_MALAY_MALAYSIA: FT_UShort = 0x043E;
pub const TT_MS_LANGID_MALAY_BRUNEI_DARUSSALAM: FT_UShort = 0x083E;
pub const TT_MS_LANGID_KAZAKH_KAZAKHSTAN: FT_UShort = 0x043F;
pub const TT_MS_LANGID_KYRGYZ_KYRGYZSTAN /* Cyrillic */ : FT_UShort =  0x0440;
pub const TT_MS_LANGID_KISWAHILI_KENYA: FT_UShort = 0x0441;
pub const TT_MS_LANGID_TURKMEN_TURKMENISTAN: FT_UShort = 0x0442;
pub const TT_MS_LANGID_UZBEK_UZBEKISTAN_LATIN: FT_UShort = 0x0443;
pub const TT_MS_LANGID_UZBEK_UZBEKISTAN_CYRILLIC: FT_UShort = 0x0843;
pub const TT_MS_LANGID_TATAR_RUSSIA: FT_UShort = 0x0444;
pub const TT_MS_LANGID_BENGALI_INDIA: FT_UShort = 0x0445;
pub const TT_MS_LANGID_BENGALI_BANGLADESH: FT_UShort = 0x0845;
pub const TT_MS_LANGID_PUNJABI_INDIA: FT_UShort = 0x0446;
pub const TT_MS_LANGID_GUJARATI_INDIA: FT_UShort = 0x0447;
pub const TT_MS_LANGID_ODIA_INDIA: FT_UShort = 0x0448;
pub const TT_MS_LANGID_TAMIL_INDIA: FT_UShort = 0x0449;
pub const TT_MS_LANGID_TELUGU_INDIA: FT_UShort = 0x044A;
pub const TT_MS_LANGID_KANNADA_INDIA: FT_UShort = 0x044B;
pub const TT_MS_LANGID_MALAYALAM_INDIA: FT_UShort = 0x044C;
pub const TT_MS_LANGID_ASSAMESE_INDIA: FT_UShort = 0x044D;
pub const TT_MS_LANGID_MARATHI_INDIA: FT_UShort = 0x044E;
pub const TT_MS_LANGID_SANSKRIT_INDIA: FT_UShort = 0x044F;
pub const TT_MS_LANGID_MONGOLIAN_MONGOLIA /* Cyrillic */: FT_UShort = 0x0450;
pub const TT_MS_LANGID_MONGOLIAN_PRC: FT_UShort = 0x0850;
pub const TT_MS_LANGID_TIBETAN_PRC: FT_UShort = 0x0451;
pub const TT_MS_LANGID_WELSH_UNITED_KINGDOM: FT_UShort = 0x0452;
pub const TT_MS_LANGID_KHMER_CAMBODIA: FT_UShort = 0x0453;
pub const TT_MS_LANGID_LAO_LAOS: FT_UShort = 0x0454;
pub const TT_MS_LANGID_GALICIAN_GALICIAN: FT_UShort = 0x0456;
pub const TT_MS_LANGID_KONKANI_INDIA: FT_UShort = 0x0457;
pub const TT_MS_LANGID_SYRIAC_SYRIA: FT_UShort = 0x045A;
pub const TT_MS_LANGID_SINHALA_SRI_LANKA: FT_UShort = 0x045B;
pub const TT_MS_LANGID_INUKTITUT_CANADA: FT_UShort = 0x045D;
pub const TT_MS_LANGID_INUKTITUT_CANADA_LATIN: FT_UShort = 0x085D;
pub const TT_MS_LANGID_AMHARIC_ETHIOPIA: FT_UShort = 0x045E;
pub const TT_MS_LANGID_TAMAZIGHT_ALGERIA: FT_UShort = 0x085F;
pub const TT_MS_LANGID_NEPALI_NEPAL: FT_UShort = 0x0461;
pub const TT_MS_LANGID_FRISIAN_NETHERLANDS: FT_UShort = 0x0462;
pub const TT_MS_LANGID_PASHTO_AFGHANISTAN: FT_UShort = 0x0463;
pub const TT_MS_LANGID_FILIPINO_PHILIPPINES: FT_UShort = 0x0464;
pub const TT_MS_LANGID_DHIVEHI_MALDIVES: FT_UShort = 0x0465;
pub const TT_MS_LANGID_HAUSA_NIGERIA: FT_UShort = 0x0468;
pub const TT_MS_LANGID_YORUBA_NIGERIA: FT_UShort = 0x046A;
pub const TT_MS_LANGID_QUECHUA_BOLIVIA: FT_UShort = 0x046B;
pub const TT_MS_LANGID_QUECHUA_ECUADOR: FT_UShort = 0x086B;
pub const TT_MS_LANGID_QUECHUA_PERU: FT_UShort = 0x0C6B;
pub const TT_MS_LANGID_SESOTHO_SA_LEBOA_SOUTH_AFRICA: FT_UShort = 0x046C;
pub const TT_MS_LANGID_BASHKIR_RUSSIA: FT_UShort = 0x046D;
pub const TT_MS_LANGID_LUXEMBOURGISH_LUXEMBOURG: FT_UShort = 0x046E;
pub const TT_MS_LANGID_GREENLANDIC_GREENLAND: FT_UShort = 0x046F;
pub const TT_MS_LANGID_IGBO_NIGERIA: FT_UShort = 0x0470;
pub const TT_MS_LANGID_YI_PRC: FT_UShort = 0x0478;
pub const TT_MS_LANGID_MAPUDUNGUN_CHILE: FT_UShort = 0x047A;
pub const TT_MS_LANGID_MOHAWK_MOHAWK: FT_UShort = 0x047C;
pub const TT_MS_LANGID_BRETON_FRANCE: FT_UShort = 0x047E;
pub const TT_MS_LANGID_UIGHUR_PRC: FT_UShort = 0x0480;
pub const TT_MS_LANGID_MAORI_NEW_ZEALAND: FT_UShort = 0x0481;
pub const TT_MS_LANGID_OCCITAN_FRANCE: FT_UShort = 0x0482;
pub const TT_MS_LANGID_CORSICAN_FRANCE: FT_UShort = 0x0483;
pub const TT_MS_LANGID_ALSATIAN_FRANCE: FT_UShort = 0x0484;
pub const TT_MS_LANGID_YAKUT_RUSSIA: FT_UShort = 0x0485;
pub const TT_MS_LANGID_KICHE_GUATEMALA: FT_UShort = 0x0486;
pub const TT_MS_LANGID_KINYARWANDA_RWANDA: FT_UShort = 0x0487;
pub const TT_MS_LANGID_WOLOF_SENEGAL: FT_UShort = 0x0488;
pub const TT_MS_LANGID_DARI_AFGHANISTAN: FT_UShort = 0x048C;
pub const TT_NAME_ID_COPYRIGHT: FT_UShort = 0;
pub const TT_NAME_ID_FONT_FAMILY: FT_UShort = 1;
pub const TT_NAME_ID_FONT_SUBFAMILY: FT_UShort = 2;
pub const TT_NAME_ID_UNIQUE_ID: FT_UShort = 3;
pub const TT_NAME_ID_FULL_NAME: FT_UShort = 4;
pub const TT_NAME_ID_VERSION_STRING: FT_UShort = 5;
pub const TT_NAME_ID_PS_NAME: FT_UShort = 6;
pub const TT_NAME_ID_TRADEMARK: FT_UShort = 7;
/* the following values are from the OpenType spec */
pub const TT_NAME_ID_MANUFACTURER: FT_UShort = 8;
pub const TT_NAME_ID_DESIGNER: FT_UShort = 9;
pub const TT_NAME_ID_DESCRIPTION: FT_UShort = 10;
pub const TT_NAME_ID_VENDOR_URL: FT_UShort = 11;
pub const TT_NAME_ID_DESIGNER_URL: FT_UShort = 12;
pub const TT_NAME_ID_LICENSE: FT_UShort = 13;
pub const TT_NAME_ID_LICENSE_URL: FT_UShort = 14;
/* number 15 is reserved  */
pub const TT_NAME_ID_TYPOGRAPHIC_FAMILY: FT_UShort = 16;
pub const TT_NAME_ID_TYPOGRAPHIC_SUBFAMILY: FT_UShort = 17;
pub const TT_NAME_ID_MAC_FULL_NAME: FT_UShort = 18;
/* The following code is new as of 2000-01-21 */
pub const TT_NAME_ID_SAMPLE_TEXT: FT_UShort = 19;
/* This is new in OpenType 1.3 */
pub const TT_NAME_ID_CID_FINDFONT_NAME: FT_UShort = 20;

/* This is new in OpenType 1.5 */
pub const TT_NAME_ID_WWS_FAMILY: FT_UShort = 21;
pub const TT_NAME_ID_WWS_SUBFAMILY: FT_UShort = 22;

/* This is new in OpenType 1.7 */
pub const TT_NAME_ID_LIGHT_BACKGROUND: FT_UShort = 23;
pub const TT_NAME_ID_DARK_BACKGROUND: FT_UShort = 24;

/* This is new in OpenType 1.8 */
pub const TT_NAME_ID_VARIATIONS_PREFIX: FT_UShort = 25;
