/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.odmg;

import java.io.Serializable;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.ObjectNotFoundException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.impl.SessionFactoryObjectFactory;
import net.sf.hibernate.odmg.Name;
import net.sf.hibernate.odmg.Transaction;
import org.odmg.ODMGException;
import org.odmg.ODMGRuntimeException;
import org.odmg.ObjectNameNotFoundException;
import org.odmg.ObjectNameNotUniqueException;

public class Database
implements org.odmg.Database {
    private SessionFactory sessionFactory;
    private final ThreadLocal threadTransaction = new ThreadLocal();
    static /* synthetic */ Class class$net$sf$hibernate$odmg$Name;

    public void open(SessionFactory factory) {
        this.sessionFactory = factory;
    }

    public Session getSession() {
        return this.currentTransaction().getSession();
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Transaction currentTransaction() {
        return (Transaction)this.threadTransaction.get();
    }

    void associateThread(Transaction trans) {
        this.threadTransaction.set(trans);
    }

    void disassociateThread() {
        this.threadTransaction.set(null);
    }

    public void open(String name, int accessMode) throws ODMGException {
        try {
            new Configuration().configure();
        }
        catch (HibernateException he) {
            throw new ODMGException(he.getMessage());
        }
        this.sessionFactory = (SessionFactory)SessionFactoryObjectFactory.getNamedInstance(name);
        if (this.sessionFactory == null) {
            throw new ODMGException("No SessionFactory was associated with the given JDNI name");
        }
    }

    public void close() throws ODMGException {
        this.sessionFactory = null;
    }

    public void bind(Object object, String name) throws ObjectNameNotUniqueException {
        try {
            Session s = this.getSession();
            Name nameObj = new Name(name, object.getClass(), s.save(object));
            s.save(nameObj);
        }
        catch (HibernateException he) {
            throw new ODMGRuntimeException(he.getMessage());
        }
    }

    public Object lookup(String name) throws ObjectNameNotFoundException {
        try {
            Name nameObj;
            Session s = this.getSession();
            try {
                nameObj = (Name)s.load(class$net$sf$hibernate$odmg$Name == null ? (class$net$sf$hibernate$odmg$Name = Database.class$("net.sf.hibernate.odmg.Name")) : class$net$sf$hibernate$odmg$Name, (Serializable)((Object)name));
            }
            catch (ObjectNotFoundException onfe) {
                throw new ObjectNameNotFoundException();
            }
            return s.load(nameObj.getPersistentClass(), nameObj.getId());
        }
        catch (HibernateException he) {
            throw new ODMGRuntimeException(he.getMessage());
        }
    }

    public void unbind(String name) throws ObjectNameNotFoundException {
        try {
            Name nameObj;
            Session s = this.getSession();
            try {
                nameObj = (Name)s.load(class$net$sf$hibernate$odmg$Name == null ? (class$net$sf$hibernate$odmg$Name = Database.class$("net.sf.hibernate.odmg.Name")) : class$net$sf$hibernate$odmg$Name, (Serializable)((Object)name));
            }
            catch (ObjectNotFoundException onfe) {
                throw new ObjectNameNotFoundException();
            }
            s.delete(nameObj);
        }
        catch (HibernateException he) {
            throw new ODMGRuntimeException(he.getMessage());
        }
    }

    public void makePersistent(Object object) {
        try {
            this.getSession().save(object);
        }
        catch (HibernateException he) {
            throw new ODMGRuntimeException(he.getMessage());
        }
    }

    public void deletePersistent(Object object) {
        try {
            this.getSession().delete(object);
        }
        catch (HibernateException he) {
            throw new ODMGRuntimeException(he.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

