/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.io.Serializable;
import java.sql.SQLException;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.impl.ScheduledCollectionAction;
import net.sf.hibernate.impl.SessionImpl;

final class ScheduledCollectionUpdate
extends ScheduledCollectionAction
implements SessionImpl.Executable {
    private final PersistentCollection collection;
    private final boolean emptySnapshot;

    public ScheduledCollectionUpdate(PersistentCollection collection, CollectionPersister persister, Serializable id, boolean emptySnapshot, SessionImplementor session) {
        super(persister, id, session);
        this.collection = collection;
        this.emptySnapshot = emptySnapshot;
    }

    public void execute() throws SQLException, HibernateException {
        this.persister.softlock(this.id);
        if (!this.collection.wasInitialized()) {
            if (!this.collection.hasQueuedAdds()) {
                throw new AssertionFailure("bug processing queued adds");
            }
        } else if (this.collection.empty()) {
            if (!this.emptySnapshot) {
                this.persister.remove(this.id, this.session);
            }
        } else if (this.collection.needsRecreate(this.persister)) {
            if (!this.emptySnapshot) {
                this.persister.remove(this.id, this.session);
            }
            this.persister.recreate(this.collection, this.id, this.session);
        } else {
            this.persister.deleteRows(this.collection, this.id, this.session);
            this.persister.updateRows(this.collection, this.id, this.session);
            this.persister.insertRows(this.collection, this.id, this.session);
        }
    }
}

