/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.expression;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.expression.Expression;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.StringHelper;

public class SQLExpression
extends Expression {
    private final String sql;
    private final TypedValue[] typedValues;

    public String toSqlString(SessionFactoryImplementor sessionFactory, Class persistentClass, String alias) throws HibernateException {
        return StringHelper.replace(this.sql, "$alias", alias);
    }

    public TypedValue[] getTypedValues(SessionFactoryImplementor sessionFactory, Class persistentClass) throws HibernateException {
        return this.typedValues;
    }

    public String toString() {
        return this.sql;
    }

    SQLExpression(String sql, Object[] values, Type[] types) {
        this.sql = sql;
        this.typedValues = new TypedValue[values.length];
        int i = 0;
        while (i < this.typedValues.length) {
            this.typedValues[i] = new TypedValue(types[i], values[i]);
            ++i;
        }
    }
}

